/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.maven;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.tomcat.ProvidedLoader;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class MeecrowaveRunMojo
extends AbstractMojo {
    @Parameter(property="meecrowave.watcher-bounding", defaultValue="0")
    private int watcherBouncing;
    @Parameter(property="meecrowave.http", defaultValue="8080")
    private int httpPort;
    @Parameter(property="meecrowave.https", defaultValue="8443")
    private int httpsPort;
    @Parameter(property="meecrowave.stop", defaultValue="8005")
    private int stopPort;
    @Parameter(property="meecrowave.host", defaultValue="localhost")
    private String host;
    @Parameter(property="meecrowave.dir")
    protected String dir;
    @Parameter(property="meecrowave.serverXml")
    private File serverXml;
    @Parameter(property="meecrowave.keepServerXmlAsThis")
    private boolean keepServerXmlAsThis;
    @Parameter(property="meecrowave.jaxrsLogProviders", defaultValue="false")
    private boolean jaxrsLogProviders;
    @Parameter(property="meecrowave.tomcatWrapLoader", defaultValue="false")
    private boolean tomcatWrapLoader;
    @Parameter(property="meecrowave.useTomcatDefaults", defaultValue="true")
    private boolean useTomcatDefaults;
    @Parameter(property="meecrowave.antiResourceLocking", defaultValue="false")
    private boolean antiResourceLocking;
    @Parameter
    private Map<String, String> properties;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter
    private Map<String, String> cxfServletParams;
    @Parameter(property="meecrowave.tomcatNoJmx", defaultValue="true")
    private boolean tomcatNoJmx;
    @Parameter(property="meecrowave.quickSession", defaultValue="true")
    private boolean quickSession;
    @Parameter(property="meecrowave.tomcatScanning", defaultValue="true")
    private boolean tomcatScanning;
    @Parameter(property="meecrowave.tomcatAutoSetup", defaultValue="true")
    private boolean tomcatAutoSetup;
    @Parameter(property="meecrowave.tomcatJspDevelopment", defaultValue="false")
    private boolean tomcatJspDevelopment;
    @Parameter(property="meecrowave.skipHttp")
    private boolean skipHttp;
    @Parameter(property="meecrowave.ssl")
    private boolean ssl;
    @Parameter(property="meecrowave.keystoreFile")
    private String keystoreFile;
    @Parameter(property="meecrowave.keystorePass")
    private String keystorePass;
    @Parameter(property="meecrowave.keystoreType", defaultValue="JKS")
    private String keystoreType;
    @Parameter(property="meecrowave.clientAuth")
    private String clientAuth;
    @Parameter(property="meecrowave.keyAlias")
    private String keyAlias;
    @Parameter(property="meecrowave.sslProtocol")
    private String sslProtocol;
    @Parameter(property="meecrowave.webXml")
    private String webXml;
    @Parameter(property="meecrowave.tomcatAccessLogPattern")
    private String tomcatAccessLogPattern;
    @Parameter
    private Meecrowave.LoginConfigBuilder loginConfig;
    @Parameter
    private Collection<Meecrowave.SecurityConstaintBuilder> securityConstraints = new LinkedList<Meecrowave.SecurityConstaintBuilder>();
    @Parameter
    private Map<String, String> users;
    @Parameter
    private Map<String, String> roles;
    @Parameter(property="meecrowave.http2")
    private boolean http2;
    @Parameter(property="meecrowave.tempDir")
    private String tempDir;
    @Parameter(property="meecrowave.webResourceCached", defaultValue="true")
    private boolean webResourceCached;
    @Parameter(property="meecrowave.conf")
    private String conf;
    @Parameter(property="meecrowave.deleteBaseOnStartup", defaultValue="true")
    private boolean deleteBaseOnStartup;
    @Parameter(property="meecrowave.jaxrsMapping", defaultValue="/*")
    private String jaxrsMapping;
    @Parameter(property="meecrowave.cdiConversation", defaultValue="false")
    private boolean cdiConversation;
    @Parameter(property="meecrowave.skip")
    private boolean skip;
    @Parameter(property="meecrowave.jaxrs-beanvalidation", defaultValue="true")
    private boolean jaxrsAutoActivateBeanValidation;
    @Parameter(property="meecrowave.jaxrs-default-providers")
    private String jaxrsDefaultProviders;
    @Parameter(property="meecrowave.jaxrs-provider-setup", defaultValue="true")
    private boolean jaxrsProviderSetup;
    @Parameter(property="meecrowave.logging-global-setup", defaultValue="true")
    private boolean loggingGlobalSetup;
    @Parameter(property="meecrowave.servlet-container-initializer-injections", defaultValue="true")
    private boolean injectServletContainerInitializer;
    @Parameter(property="meecrowave.shutdown-hook", defaultValue="true")
    private boolean useShutdownHook;
    @Parameter(property="meecrowave.initialiaze-client-bus", defaultValue="true")
    private boolean initializeClientBus;
    @Parameter
    private List<String> jsCustomizers;
    @Parameter
    private List<String> applicationScopes;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private List<File> modules;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="meecrowave.tomcatFilter")
    private String tomcatFilter;
    @Parameter(property="meecrowave.context", defaultValue="")
    private String context;
    @Parameter(property="meecrowave.shared-libraries")
    private String sharedLibraries;
    @Parameter(property="meecrowave.log4j2-jul-bridge", defaultValue="true")
    private boolean useLog4j2JulLogManager;
    @Parameter(property="meecrowave.jsonp-buffer-strategy", defaultValue="QUEUE")
    private String jsonpBufferStrategy;
    @Parameter(property="meecrowave.jsonp-max-string-length", defaultValue="10485760")
    private int jsonpMaxStringLen;
    @Parameter(property="meecrowave.jsonp-max-read-buffer-size", defaultValue="65536")
    private int jsonpMaxReadBufferLen;
    @Parameter(property="meecrowave.jsonp-max-write-buffer-size", defaultValue="65536")
    private int jsonpMaxWriteBufferLen;
    @Parameter(property="meecrowave.jsonp-comments", defaultValue="false")
    private boolean jsonpSupportsComment;
    @Parameter(property="meecrowave.jsonp-prettify", defaultValue="false")
    private boolean jsonpPrettify;
    @Parameter(property="meecrowave.jsonb-encoding", defaultValue="UTF-8")
    private String jsonbEncoding;
    @Parameter(property="meecrowave.jsonb-nulls", defaultValue="false")
    private boolean jsonbNulls = false;
    @Parameter(property="meecrowave.jsonb-ijson", defaultValue="false")
    private boolean jsonbIJson;
    @Parameter(property="meecrowave.jsonb-prettify", defaultValue="false")
    private boolean jsonbPrettify;
    @Parameter(property="meecrowave.jsonb-binary-strategy")
    private String jsonbBinaryStrategy;
    @Parameter(property="meecrowave.jsonb-naming-strategy")
    private String jsonbNamingStrategy;
    @Parameter(property="meecrowave.jsonb-order-strategy")
    private String jsonbOrderStrategy;
    @Parameter(property="meecrowave.scanning-include")
    private String scanningIncludes;
    @Parameter(property="meecrowave.scanning-exclude")
    private String scanningExcludes;
    @Parameter(property="meecrowave.scanning-package-include")
    private String scanningPackageIncludes;
    @Parameter(property="meecrowave.scanning-package-exclude")
    private String scanningPackageExcludes;
    @Parameter(property="meecrowave.force-log4j2-shutdown", defaultValue="true")
    private boolean forceLog4j2Shutdown;
    @Parameter(property="meecrowave.webapp", defaultValue="${project.basedir}/src/main/webapp")
    private File webapp;
    @Parameter(property="meecrowave.force-classpath-deployment", defaultValue="true")
    private boolean useClasspathDeployment;
    @Parameter
    private String jsContextCustomizer;
    @Parameter(property="meecrowave.meecrowave-properties", defaultValue="meecrowave.properties")
    private String meecrowaveProperties;
    @Parameter(property="meecrowave.jaxws-support", defaultValue="true")
    private boolean jaxwsSupportIfAvailable;
    @Parameter(property="meecrowave.reload-goals")
    private List<String> reloadGoals;
    @Parameter(property="meecrowave.default-ssl-hostconfig-name")
    private String defaultSSLHostConfigName;
    @Parameter(property="meecrowave.session-timeout")
    private Integer webSessionTimeout;
    @Parameter(property="meecrowave.session-cookie-config")
    private String webSessionCookieConfig;
    @Component
    private LifecycleStarter lifecycleStarter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Map originalSystemProps;
        if (this.skip) {
            this.getLog().warn((CharSequence)"Mojo skipped");
            return;
        }
        if (this.watcherBouncing <= 0 && (this.reloadGoals == null || this.reloadGoals.isEmpty())) {
            try {
                this.reloadGoals = Collections.singletonList("process-classes");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.logConfigurationErrors();
        if (this.systemProperties != null) {
            originalSystemProps = this.systemProperties.keySet().stream().filter(System.getProperties()::containsKey).collect(Collectors.toMap(Function.identity(), System::getProperty));
            this.systemProperties.forEach(System::setProperty);
        } else {
            originalSystemProps = null;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        Supplier<ClassLoader> appLoaderSupplier = this.createClassLoader(loader);
        thread.setContextClassLoader(appLoaderSupplier.get());
        try {
            Configuration builder = this.getConfig();
            try (Meecrowave meecrowave = new Meecrowave(builder){

                protected void beforeStart() {
                    MeecrowaveRunMojo.this.scriptCustomization(MeecrowaveRunMojo.this.jsCustomizers, "js", Collections.singletonMap("meecrowaveBase", this.base.getAbsolutePath()));
                }
            };){
                String cmd;
                meecrowave.start();
                String fixedContext = Optional.ofNullable(this.context).orElse("");
                Meecrowave.DeploymentMeta deploymentMeta = new Meecrowave.DeploymentMeta(fixedContext, this.webapp != null && this.webapp.isDirectory() ? this.webapp : null, this.jsContextCustomizer == null ? null : ctx -> this.scriptCustomization(Collections.singletonList(this.jsContextCustomizer), "js", Collections.singletonMap("context", ctx)), context -> this.reload(meecrowave, fixedContext, appLoaderSupplier, loader));
                this.deploy(meecrowave, deploymentMeta);
                Scanner scanner = new Scanner(System.in);
                boolean quit = false;
                block27: while (!quit && (cmd = scanner.next()) != null) {
                    switch (cmd = cmd.trim()) {
                        case "": 
                        case "q": 
                        case "quit": 
                        case "e": 
                        case "exit": {
                            quit = true;
                            continue block27;
                        }
                        case "r": 
                        case "reload": {
                            this.reload(meecrowave, fixedContext, appLoaderSupplier, loader);
                            continue block27;
                        }
                    }
                    this.getLog().error((CharSequence)("Unknown command: '" + cmd + "', use 'quit' or 'exit' or 'reload'"));
                }
            }
        }
        finally {
            if (this.forceLog4j2Shutdown) {
                LogManager.shutdown();
            }
            this.destroyTcclIfNeeded(thread, loader);
            thread.setContextClassLoader(loader);
            if (originalSystemProps != null) {
                this.systemProperties.keySet().forEach(k -> {
                    Optional originalValue = Optional.ofNullable(originalSystemProps.get(k));
                    if (originalValue.isPresent()) {
                        System.setProperty(k, (String)originalValue.get());
                    } else {
                        System.clearProperty(k);
                    }
                });
            }
        }
    }

    private void destroyTcclIfNeeded(Thread thread, ClassLoader loader) {
        if (thread.getContextClassLoader() != loader) {
            try {
                ((URLClassLoader)URLClassLoader.class.cast(thread.getContextClassLoader())).close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void logConfigurationErrors() {
        if (this.watcherBouncing > 0 && this.reloadGoals != null && !this.reloadGoals.isEmpty()) {
            this.getLog().warn((CharSequence)"You set reloadGoals and watcherBouncing > 1, behavior is undefined");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(Meecrowave meecrowave, String context, Supplier<ClassLoader> loaderSupplier, ClassLoader mojoLoader) {
        if (this.reloadGoals != null && !this.reloadGoals.isEmpty()) {
            List goals = this.session.getGoals();
            this.session.getRequest().setGoals(this.reloadGoals);
            try {
                this.lifecycleStarter.execute(this.session);
            }
            finally {
                this.session.getRequest().setGoals(goals);
            }
        }
        Context ctx = (Context)Context.class.cast(meecrowave.getTomcat().getHost().findChild(context));
        if (this.useClasspathDeployment) {
            Thread thread = Thread.currentThread();
            this.destroyTcclIfNeeded(thread, mojoLoader);
            thread.setContextClassLoader(loaderSupplier.get());
            ctx.setLoader((Loader)new ProvidedLoader(thread.getContextClassLoader(), meecrowave.getConfiguration().isTomcatWrapLoader()));
        }
        ctx.reload();
    }

    private void deploy(Meecrowave meecrowave, Meecrowave.DeploymentMeta deploymentMeta) {
        if (this.useClasspathDeployment) {
            meecrowave.deployClasspath(deploymentMeta);
        } else {
            meecrowave.deployWebapp(deploymentMeta);
        }
    }

    private void scriptCustomization(List<String> customizers, String ext, Map<String, Object> customBindings) {
        if (customizers == null || customizers.isEmpty()) {
            return;
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByExtension(ext);
        if (engine == null) {
            throw new IllegalStateException("No engine for " + ext + ". Maybe add the JSR223 implementation as plugin dependency.");
        }
        for (String js : customizers) {
            try {
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("project", (Object)this.project);
                engine.eval((Reader)new StringReader(js), (Bindings)bindings);
                bindings.putAll((Map<? extends String, ? extends Object>)customBindings);
            }
            catch (ScriptException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private Supplier<ClassLoader> createClassLoader(final ClassLoader parent) {
        ArrayList urls = new ArrayList();
        urls.addAll(this.project.getArtifacts().stream().filter(a -> !(this.applicationScopes == null && !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope()) || this.applicationScopes != null && !this.applicationScopes.contains(a.getScope()))).map(f -> {
            try {
                return f.getFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList()));
        urls.addAll(Optional.ofNullable(this.modules).orElse(Collections.emptyList()).stream().map(f -> {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList()));
        return urls.isEmpty() ? () -> parent : () -> new URLClassLoader(urls.toArray(new URL[0]), parent){

            public boolean equals(Object obj) {
                return super.equals(obj) || parent.equals(obj);
            }
        };
    }

    private Configuration getConfig() {
        Configuration config = new Configuration();
        for (Field field : MeecrowaveRunMojo.class.getDeclaredFields()) {
            if ("properties".equals(field.getName())) continue;
            try {
                Field configField = Configuration.class.getDeclaredField(field.getName());
                field.setAccessible(true);
                configField.setAccessible(true);
                Object value = field.get((Object)this);
                if (value == null) continue;
                configField.set(config, value);
                this.getLog().debug((CharSequence)("using " + field.getName() + " = " + value));
            }
            catch (NoSuchFieldException configField) {
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("can't initialize attribute " + field.getName()));
            }
        }
        config.loadFrom(this.meecrowaveProperties);
        if (this.properties != null) {
            config.getProperties().putAll(this.properties);
        }
        return config;
    }
}

