/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.testing;

import java.io.File;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.internal.ClassLoaderLock;

public class MonoBase {
    private static final AtomicReference<Instance> CONTAINER = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meecrowave.Builder doBoot() {
        block11: {
            Meecrowave.Builder configuration = new Meecrowave.Builder().randomHttpPort().noShutdownHook();
            boolean unlocked = false;
            ClassLoaderLock.LOCK.lock();
            try {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                ClassLoaderLock.LOCK.lock();
                ClassLoader containerLoader = ClassLoaderLock.getUsableContainerLoader();
                final Meecrowave meecrowave = new Meecrowave(configuration);
                if (!CONTAINER.compareAndSet(null, new Instance(meecrowave, configuration, containerLoader))) break block11;
                final Configuration runnerConfig = StreamSupport.stream(ServiceLoader.load(Configuration.class).spliterator(), false).min(Comparator.comparingInt(Configuration::order)).orElseGet(() -> new Configuration(){});
                runnerConfig.beforeStarts();
                File war = runnerConfig.application();
                Thread thread = Thread.currentThread();
                if (containerLoader != originalCL) {
                    thread.setContextClassLoader(containerLoader);
                }
                try {
                    if (war == null) {
                        meecrowave.bake(runnerConfig.context());
                    } else {
                        meecrowave.deployWebapp(runnerConfig.context(), runnerConfig.application());
                    }
                }
                finally {
                    if (containerLoader != originalCL) {
                        thread.setContextClassLoader(originalCL);
                    }
                }
                ClassLoaderLock.LOCK.unlock();
                unlocked = true;
                runnerConfig.afterStarts();
                Runtime.getRuntime().addShutdownHook(new Thread(){
                    {
                        this.setName("Meecrowave-mono-rule-stopping");
                    }

                    @Override
                    public void run() {
                        try {
                            runnerConfig.beforeStops();
                        }
                        finally {
                            try {
                                meecrowave.close();
                            }
                            finally {
                                runnerConfig.afterStops();
                            }
                        }
                    }
                });
            }
            finally {
                if (!unlocked) {
                    ClassLoaderLock.LOCK.unlock();
                }
            }
        }
        return this.getConfiguration();
    }

    public Meecrowave.Builder getConfiguration() {
        return CONTAINER.get().configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance startIfNeeded() {
        if (CONTAINER.get() == null) {
            AtomicReference<Instance> atomicReference = CONTAINER;
            synchronized (atomicReference) {
                if (CONTAINER.get() == null) {
                    this.doBoot();
                }
            }
        }
        return CONTAINER.get();
    }

    public static interface Configuration {
        default public int order() {
            return 0;
        }

        default public String context() {
            return "";
        }

        default public File application() {
            return null;
        }

        default public void beforeStarts() {
        }

        default public void afterStarts() {
        }

        default public void beforeStops() {
        }

        default public void afterStops() {
        }
    }

    public static final class Instance {
        private final Meecrowave container;
        private final Meecrowave.Builder configuration;
        private final ClassLoader startupClassLoader;

        private Instance(Meecrowave container, Meecrowave.Builder configuration, ClassLoader startupClassLoader) {
            this.container = container;
            this.configuration = configuration;
            this.startupClassLoader = startupClassLoader;
        }

        public Meecrowave getContainer() {
            return this.container;
        }

        public Meecrowave.Builder getConfiguration() {
            return this.configuration;
        }

        public ClassLoader getStartupClassLoader() {
            return this.startupClassLoader;
        }
    }
}

