/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ScopeRule
implements TestRule {
    private final List<Class<? extends Annotation>> scopes;

    public ScopeRule(Class<?> ... scopes) {
        this.scopes = new ArrayList(Arrays.asList(scopes));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
                try {
                    ScopeRule.this.scopes.forEach(s -> contextsService.startContext(s, null));
                    base.evaluate();
                }
                finally {
                    Collections.reverse(ScopeRule.this.scopes);
                    ScopeRule.this.scopes.forEach(s -> contextsService.endContext(s, null));
                    Collections.reverse(ScopeRule.this.scopes);
                }
            }
        };
    }
}

