/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.internal.ClassLoaderLock;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class MeecrowaveRuleBase<T extends MeecrowaveRuleBase>
implements TestRule {
    private final Collection<Object> toInject = new ArrayList<Object>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ClassLoader meecrowaveCL;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Thread thread = Thread.currentThread();
                ClassLoader oldCL = thread.getContextClassLoader();
                boolean unlocked = false;
                MeecrowaveRuleBase.this.doLockContext();
                try {
                    ClassLoader newCl = MeecrowaveRuleBase.this.getClassLoader();
                    if (newCl != null) {
                        thread.setContextClassLoader(newCl);
                    }
                    try (AutoCloseable closeable = MeecrowaveRuleBase.this.onStart();){
                        MeecrowaveRuleBase.this.doUnlockContext(unlocked);
                        unlocked = true;
                        MeecrowaveRuleBase.this.started.set(true);
                        Collection contexts = MeecrowaveRuleBase.this.toInject.stream().map(x$0 -> MeecrowaveRuleBase.doInject(x$0)).collect(Collectors.toList());
                        try {
                            base.evaluate();
                        }
                        finally {
                            contexts.forEach(CreationalContext::release);
                            MeecrowaveRuleBase.this.started.set(false);
                        }
                    }
                    finally {
                        thread.setContextClassLoader(oldCL);
                    }
                }
                finally {
                    MeecrowaveRuleBase.this.doUnlockContext(unlocked);
                }
            }
        };
    }

    protected void doUnlockContext(boolean unlocked) {
        if (!unlocked) {
            ClassLoaderLock.LOCK.unlock();
        }
    }

    protected void doLockContext() {
        ClassLoaderLock.LOCK.lock();
    }

    private static CreationalContext<Object> doInject(Object instance) {
        BeanManager bm = CDI.current().getBeanManager();
        AnnotatedType annotatedType = bm.createAnnotatedType(instance.getClass());
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        CreationalContext creationalContext = bm.createCreationalContext(null);
        injectionTarget.inject(instance, creationalContext);
        return creationalContext;
    }

    public <T> T inject(Object instance) {
        if (this.started.get()) {
            MeecrowaveRuleBase.doInject(instance);
        } else {
            this.toInject.add(instance);
        }
        return (T)this;
    }

    public abstract Meecrowave.Builder getConfiguration();

    protected abstract AutoCloseable onStart();

    protected ClassLoader getClassLoader() {
        if (this.meecrowaveCL == null) {
            this.meecrowaveCL = ClassLoaderLock.getUsableContainerLoader();
        }
        return this.meecrowaveCL;
    }
}

