/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit5;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.meecrowave.junit5.Scopes;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ScopesExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ScopesExtension.class.getName()});

    public void beforeEach(ExtensionContext extensionContext) {
        this.getScopes(extensionContext).ifPresent(scopes -> {
            ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
            Stream.of(scopes).forEach(s -> contextsService.startContext(s, null));
            extensionContext.getStore(NAMESPACE).put(Holder.class, (Object)new Holder((Class[])scopes));
        });
    }

    public void afterEach(ExtensionContext extensionContext) {
        Optional.ofNullable(extensionContext.getStore(NAMESPACE).get(Holder.class, Holder.class)).map(h -> ((Holder)h).scopes).ifPresent(scopes -> {
            ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(scopes));
            Collections.reverse(list);
            list.forEach(s -> contextsService.endContext(s, null));
        });
    }

    protected Optional<Class<? extends Annotation>[]> getScopes(ExtensionContext context) {
        return context.getElement().map(e -> Optional.ofNullable(e.getAnnotation(Scopes.class)).orElseGet(() -> context.getParent().flatMap(ExtensionContext::getElement).map(it -> it.getAnnotation(Scopes.class)).orElse(null))).map(Scopes::scopes).filter(s -> ((Class[])s).length > 0);
    }

    private static class Holder {
        private final Class<? extends Annotation>[] scopes;

        private Holder(Class<? extends Annotation>[] scopes) {
            this.scopes = scopes;
        }
    }
}

