/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.junit;

import jakarta.enterprise.context.spi.CreationalContext;
import java.util.List;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.junit.MeecrowaveRuleBase;
import org.apache.meecrowave.testing.Injector;
import org.apache.meecrowave.testing.MonoBase;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class MonoMeecrowave {
    private static final MonoBase BASE = new MonoBase();

    public static class Rule
    extends MeecrowaveRuleBase<Rule> {
        @Override
        public Meecrowave.Builder getConfiguration() {
            return BASE.getConfiguration();
        }

        @Override
        protected AutoCloseable onStart() {
            MonoBase.Instance instance = BASE.startIfNeeded();
            Thread thread = Thread.currentThread();
            ClassLoader originalLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(instance.getStartupClassLoader());
            return () -> thread.setContextClassLoader(originalLoader);
        }

        @Override
        protected void doUnlockContext(boolean unlocked) {
        }

        @Override
        protected void doLockContext() {
        }
    }

    public static class Runner
    extends BlockJUnit4ClassRunner {
        public Runner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        protected List<MethodRule> rules(final Object test) {
            List rules = super.rules(test);
            rules.add((base, method, target) -> new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    MonoBase.Instance instance = BASE.startIfNeeded();
                    Thread thread = Thread.currentThread();
                    ClassLoader originalLoader = thread.getContextClassLoader();
                    thread.setContextClassLoader(instance.getStartupClassLoader());
                    try {
                        this.configInjection(test.getClass(), test);
                        CreationalContext<?> creationalContext = Injector.inject(test);
                        try {
                            base.evaluate();
                        }
                        finally {
                            creationalContext.release();
                        }
                    }
                    finally {
                        thread.setContextClassLoader(originalLoader);
                    }
                }

                private void configInjection(Class<?> aClass, Object test2) {
                    Injector.injectConfig(BASE.getConfiguration(), test2);
                    Class<?> parent = aClass.getSuperclass();
                    if (parent != null && parent != Object.class) {
                        this.configInjection(parent, true);
                    }
                }
            });
            return rules;
        }
    }
}

