/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.jpa.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.meecrowave.jpa.api.EntityManagerScoped;

public class EntityManagerContext
implements AlterableContext {
    private final ThreadLocal<ThreadContext> context = new ThreadLocal();

    public boolean enter(boolean transactional) {
        if (this.context.get() != null) {
            return false;
        }
        ThreadContext value = new ThreadContext();
        value.transactional = transactional;
        this.context.set(value);
        return true;
    }

    public void failed() {
        this.context.get().failed = true;
    }

    public void exit(boolean created) {
        if (created) {
            try {
                this.context.get().exit();
            }
            finally {
                this.context.remove();
            }
        }
    }

    public Class<? extends Annotation> getScope() {
        return EntityManagerScoped.class;
    }

    public void destroy(Contextual<?> contextual) {
        this.context.get().destroy(contextual);
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        return this.context.get().get(component, creationalContext);
    }

    public <T> T get(Contextual<T> component) {
        return this.context.get().get(component);
    }

    public boolean isActive() {
        boolean active;
        boolean bl = active = this.context.get() != null;
        if (!active) {
            this.context.remove();
        }
        return active;
    }

    public boolean hasFailed() {
        return this.context.get().failed;
    }

    public boolean isTransactional() {
        return this.context.get().transactional;
    }

    private static class BeanInstanceBag<T>
    implements Serializable {
        private final CreationalContext<T> beanCreationalContext;
        private T beanInstance;

        private BeanInstanceBag(CreationalContext<T> beanCreationalContext) {
            this.beanCreationalContext = beanCreationalContext;
        }
    }

    private static class ThreadContext
    implements AlterableContext {
        private final Map<Contextual<?>, BeanInstanceBag<?>> components = new HashMap();
        private boolean failed;
        private boolean transactional;

        private ThreadContext() {
        }

        public Class<? extends Annotation> getScope() {
            return EntityManagerScoped.class;
        }

        public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
            BeanInstanceBag<Object> bag = this.components.get(component);
            if (bag == null) {
                bag = new BeanInstanceBag(creationalContext);
                this.components.put(component, bag);
            }
            if (((BeanInstanceBag)bag).beanInstance == null) {
                ((BeanInstanceBag)bag).beanInstance = component.create(creationalContext);
            }
            return (T)((BeanInstanceBag)bag).beanInstance;
        }

        public <T> T get(Contextual<T> component) {
            BeanInstanceBag<?> bag = this.components.get(component);
            return (T)(bag == null ? null : ((BeanInstanceBag)bag).beanInstance);
        }

        public void destroy(Contextual<?> contextual) {
            BeanInstanceBag<?> remove = this.components.remove(contextual);
            Optional.ofNullable(remove).ifPresent(b -> this.doDestroy((Contextual)contextual, (BeanInstanceBag)b));
        }

        private <T> void doDestroy(Contextual<T> contextual, BeanInstanceBag<T> bag) {
            if (((BeanInstanceBag)bag).beanInstance != null) {
                contextual.destroy(((BeanInstanceBag)bag).beanInstance, ((BeanInstanceBag)bag).beanCreationalContext);
            }
            ((BeanInstanceBag)bag).beanCreationalContext.release();
        }

        public boolean isActive() {
            return true;
        }

        private void exit() {
            this.components.forEach((k, bag) -> this.doDestroy((Contextual)k, (BeanInstanceBag)BeanInstanceBag.class.cast(bag)));
        }
    }
}

