/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.fixture;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.util.Base64;

public class ProxyAuthenticationFilter
implements Filter {
    private final String username;
    private final String password;

    public ProxyAuthenticationFilter(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String header = request.getHeader("Proxy-Authorization");
        if (header == null) {
            response.setStatus(407);
            response.addHeader("Proxy-Authenticate", "Basic realm=\"Squid proxy-caching web server\"");
            return;
        }
        String data = header.substring("BASIC ".length());
        String[] creds = (data = new String(Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.US_ASCII)))).split(":");
        if (!creds[0].equals(this.username) || !creds[1].equals(this.password)) {
            response.sendError(401);
        }
        chain.doFilter(req, resp);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

