/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http;

import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import junit.framework.Assert;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.tck.http.Assertions;
import org.apache.maven.wagon.tck.http.HttpWagonTests;
import org.apache.maven.wagon.tck.http.fixture.ErrorCodeServlet;
import org.apache.maven.wagon.tck.http.fixture.LatencyServlet;
import org.apache.maven.wagon.tck.http.fixture.ProxyConnectionVerifierFilter;
import org.apache.maven.wagon.tck.http.fixture.RedirectionServlet;
import org.apache.maven.wagon.tck.http.fixture.ServletExceptionServlet;
import org.apache.maven.wagon.tck.http.util.ValueHolder;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.junit.Ignore;
import org.junit.Test;

public class GetWagonTests
extends HttpWagonTests {
    private static final int TWO_SECONDS = 2000;
    private static final int ONE_MINUTE = 60000;

    @Test
    public void basic() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.testSuccessfulGet("base.txt");
    }

    @Test
    @Ignore(value="FIX ME!")
    public void proxied() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getServerFixture().addFilter("*", new ProxyConnectionVerifierFilter());
        ProxyInfo info = this.newProxyInfo();
        if (!this.initTest(null, info)) {
            return;
        }
        File target = this.newTempFile();
        this.getWagon().get("base.txt", target);
        Assertions.assertFileContentsFromResource("default-server-root", "base.txt", target, "Downloaded file doesn't match original.");
    }

    @Test
    public void highLatencyHighTimeout() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getServerFixture().addServlet("/slow/*", (Servlet)new LatencyServlet(2000));
        this.testSuccessfulGet("slow/large.txt", "large.txt");
    }

    @Test
    public void highLatencyLowTimeout() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        LatencyServlet servlet = new LatencyServlet(2000);
        this.getServerFixture().addServlet("/slow/*", (Servlet)servlet);
        this.testSuccessfulGet("slow/large.txt", "large.txt");
    }

    @Test
    public void inifiniteLatencyTimeout() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!this.isSupported()) {
            return;
        }
        final ValueHolder<Object> holder = new ValueHolder<Object>(null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LatencyServlet servlet = new LatencyServlet(-1);
                GetWagonTests.this.addNotificationTarget((Object)servlet);
                GetWagonTests.this.getServerFixture().addServlet("/infinite/*", (Servlet)servlet);
                try {
                    if (!GetWagonTests.this.initTest(null, null)) {
                        return;
                    }
                    if (GetWagonTests.this.getWagon() instanceof StreamWagon) {
                        HttpWagonTests.logger.info("Connection timeout is: " + GetWagonTests.this.getWagon().getTimeout());
                    }
                    File target = GetWagonTests.this.newTempFile();
                    GetWagonTests.this.getWagon().get("infinite/", target);
                    Assert.fail((String)"Should have failed to transfer due to transaction timeout.");
                }
                catch (IOException | ConnectionException | ResourceDoesNotExistException | AuthenticationException | AuthorizationException | ComponentConfigurationException e) {
                    throw new IllegalStateException(e);
                }
                catch (TransferFailedException e) {
                    holder.setValue(e);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        try {
            logger.info("Waiting 60 seconds for wagon timeout.");
            t.join(60000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("Interrupting thread.");
        t.interrupt();
        Assert.assertTrue((String)"TransferFailedException should have been thrown.", (holder.getValue() != null ? 1 : 0) != 0);
        Assertions.assertWagonExceptionMessage(holder.getValue(), -1, this.getBaseUrl() + "infinite/", "", null);
    }

    @Test
    public void nonExistentHost() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, ResourceDoesNotExistException, AuthorizationException {
        if (!this.initTest("http://localhost:65520", null, null)) {
            return;
        }
        File target = this.newTempFile();
        try {
            this.getWagon().get("base.txt", target);
            Assert.fail((String)"Expected error related to host lookup failure.");
        }
        catch (TransferFailedException e) {
            Assertions.assertWagonExceptionMessage((Exception)((Object)e), -1, "http://localhost:65520/base.txt", null, null);
        }
    }

    @Test
    public void oneLevelPermanentMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getServerFixture().addServlet("/moved.txt", (Servlet)new RedirectionServlet(301, "/base.txt"));
        this.testSuccessfulGet("moved.txt");
    }

    @Test
    public void oneLevelTemporaryMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getServerFixture().addServlet("/moved.txt", (Servlet)new RedirectionServlet(302, "/base.txt"));
        this.testSuccessfulGet("moved.txt");
    }

    @Test
    public void sixLevelPermanentMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath + "/*", (Servlet)new RedirectionServlet(301, myPath, targetPath, 6));
        this.testSuccessfulGet(myPath);
    }

    @Test
    public void sixLevelTemporaryMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath + "/*", (Servlet)new RedirectionServlet(302, myPath, targetPath, 6));
        this.testSuccessfulGet(myPath);
    }

    @Test
    public void infinitePermanentMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath, (Servlet)new RedirectionServlet(301, myPath, targetPath, -1));
        try {
            this.testSuccessfulGet(myPath);
            Assert.fail((String)"Expected failure as a result of too many redirects.");
        }
        catch (TransferFailedException transferFailedException) {
            // empty catch block
        }
    }

    @Test
    public void infiniteTemporaryMove() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath, (Servlet)new RedirectionServlet(302, myPath, targetPath, -1));
        try {
            this.testSuccessfulGet(myPath);
            Assert.fail((String)"Expected failure as a result of too many redirects.");
        }
        catch (TransferFailedException transferFailedException) {
            // empty catch block
        }
    }

    @Test
    public void permanentMove_TooManyRedirects_limit20() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath, (Servlet)new RedirectionServlet(301, myPath, targetPath, -1));
        try {
            this.testSuccessfulGet(myPath);
            Assert.fail((String)"Expected failure as a result of too many redirects.");
        }
        catch (TransferFailedException transferFailedException) {
            // empty catch block
        }
    }

    @Test
    public void temporaryMove_TooManyRedirects_limit20() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, ResourceDoesNotExistException, AuthorizationException {
        String myPath = "moved.txt";
        String targetPath = "/base.txt";
        this.getServerFixture().addServlet("/" + myPath, (Servlet)new RedirectionServlet(302, myPath, targetPath, -1));
        try {
            this.testSuccessfulGet(myPath);
            Assert.fail((String)"Expected failure as a result of too many redirects.");
        }
        catch (TransferFailedException transferFailedException) {
            // empty catch block
        }
    }

    @Test
    public void missing() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, AuthorizationException {
        if (!this.initTest(null, null)) {
            return;
        }
        File target = this.newTempFile();
        try {
            this.getWagon().get("404.txt", target);
            Assert.fail((String)"should have received a 404, meaning the resource doesn't exist.");
        }
        catch (ResourceDoesNotExistException resourceDoesNotExistException) {
            // empty catch block
        }
    }

    @Test
    public void error() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, AuthorizationException, ResourceDoesNotExistException {
        this.testErrorHandling(500);
    }

    @Test
    public void proxyTimeout() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, AuthorizationException, ResourceDoesNotExistException {
        this.testErrorHandling(504);
    }

    @Test
    public void forbidden() throws ConnectionException, ComponentConfigurationException, IOException, ResourceDoesNotExistException, TransferFailedException {
        AuthenticationInfo info = new AuthenticationInfo();
        info.setUserName("user");
        info.setPassword("password");
        this.getServerFixture().addUser(info.getUserName(), "password");
        this.getServerFixture().addServlet("/403.txt", (Servlet)new ErrorCodeServlet(403, "Expected 403"));
        this.testAuthFailure("403.txt", info);
    }

    @Test
    public void successfulAuthentication() throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        AuthenticationInfo info = new AuthenticationInfo();
        info.setUserName("user");
        info.setPassword("password");
        this.getServerFixture().addUser(info.getUserName(), info.getPassword());
        if (!this.initTest(info, null)) {
            return;
        }
        File target = this.newTempFile();
        this.getWagon().get("protected/base.txt", target);
        Assertions.assertFileContentsFromResource("default-server-root", "base.txt", target, "Downloaded file doesn't match original.");
    }

    @Test
    public void unsuccessfulAuthentication() throws ConnectionException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException {
        AuthenticationInfo info = new AuthenticationInfo();
        info.setUserName("user");
        info.setPassword("password");
        this.getServerFixture().addUser(info.getUserName(), "anotherPassword");
        this.testAuthFailure("protected/base.txt", info);
    }

    protected void testAuthFailure(String path, AuthenticationInfo info) throws ConnectionException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException {
        boolean authFailure = false;
        try {
            if (!this.initTest(info, null)) {
                return;
            }
        }
        catch (AuthenticationException e) {
            authFailure = true;
        }
        File target = this.newTempFile();
        try {
            this.getWagon().get(path, target);
        }
        catch (AuthorizationException e) {
            authFailure = true;
        }
        Assert.assertTrue((String)"Authentication/Authorization should have failed.", (boolean)authFailure);
    }

    protected void testSuccessfulGet(String path) throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.testSuccessfulGet(path, "base.txt");
    }

    protected void testSuccessfulGet(String path, String checkPath) throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!this.initTest(null, null)) {
            return;
        }
        if (this.getWagon() instanceof StreamWagon) {
            logger.info("Connection timeout is: " + this.getWagon().getTimeout());
        }
        File target = this.newTempFile();
        this.getWagon().get(path, target);
        Assertions.assertFileContentsFromResource("default-server-root", checkPath, target, "Downloaded file doesn't match original.");
    }

    protected void testErrorHandling(int code) throws ConnectionException, AuthenticationException, ComponentConfigurationException, IOException, AuthorizationException, ResourceDoesNotExistException {
        if (code == 500) {
            this.getServerFixture().addServlet("/" + code + ".txt", (Servlet)new ServletExceptionServlet("Expected " + code));
        } else {
            this.getServerFixture().addServlet("/" + code + ".txt", (Servlet)new ErrorCodeServlet(code, "Expected " + code));
        }
        if (!this.initTest(null, null)) {
            return;
        }
        File target = this.newTempFile();
        try {
            this.getWagon().get(code + ".txt", target);
            Assert.fail((String)("should have received a " + code + " error code, meaning the resource doesn't exist."));
        }
        catch (TransferFailedException transferFailedException) {
            // empty catch block
        }
    }
}

