/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Assertions {
    public static final int NO_RESPONSE_STATUS_CODE = -1;
    protected static final Logger LOGGER = LoggerFactory.getLogger(Assertions.class);

    public static void assertFileContentsFromResource(String resourceBase, String resourceName, File output, String whyWouldItFail) throws IOException {
        String content = Assertions.readResource(resourceBase, resourceName);
        String test = FileUtils.fileRead((File)output);
        Assert.assertEquals((String)whyWouldItFail, (Object)content, (Object)test);
    }

    private static String readResource(String base, String name) throws IOException {
        String url = base;
        if (!url.endsWith("/") && !name.startsWith("/")) {
            url = url + "/";
        }
        url = url + name;
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        InputStream stream = cloader.getResourceAsStream(url);
        if (stream == null) {
            return null;
        }
        String resource = IOUtil.toString((InputStream)stream);
        stream.close();
        return resource;
    }

    public static void assertWagonExceptionMessage(Exception e, int forStatusCode, String forUrl, String forReasonPhrase, ProxyInfo proxyInfo) {
        Assert.assertNotNull((Object)e);
        try {
            Assert.assertTrue((String)"only verify instances of WagonException", (boolean)(e instanceof WagonException));
            String assertMessageForBadMessage = "exception message not described properly";
            if (proxyInfo != null) {
                Assert.assertTrue((String)"message should end with proxy information if proxy was used", (boolean)e.getMessage().endsWith(proxyInfo.toString()));
            }
            switch (forStatusCode) {
                case 404: {
                    Assert.assertTrue((String)"404 not found response should throw ResourceDoesNotExistException", (boolean)(e instanceof ResourceDoesNotExistException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Not Found" : " " + forReasonPhrase;
                    Assert.assertEquals((String)assertMessageForBadMessage, (Object)("resource missing at " + forUrl + ", status: 404" + reasonPhrase), (Object)e.getMessage());
                    break;
                }
                case 401: {
                    Assert.assertTrue((String)"401 Unauthorized should throw AuthorizationException since  AuthenticationException is not explicitly declared as thrown from wagon methods", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Unauthorized" : " " + forReasonPhrase;
                    Assert.assertEquals((String)assertMessageForBadMessage, (Object)("authentication failed for " + forUrl + ", status: 401" + reasonPhrase), (Object)e.getMessage());
                    break;
                }
                case 407: {
                    Assert.assertTrue((String)"407 Proxy authentication required should throw AuthorizationException", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Proxy Authentication Required" : " " + forReasonPhrase;
                    Assert.assertEquals((String)assertMessageForBadMessage, (Object)("proxy authentication failed for " + forUrl + ", status: 407" + reasonPhrase), (Object)e.getMessage());
                    break;
                }
                case 403: {
                    Assert.assertTrue((String)"403 Forbidden should throw AuthorizationException", (boolean)(e instanceof AuthorizationException));
                    String reasonPhrase = StringUtils.isEmpty((String)forReasonPhrase) ? " Forbidden" : " " + forReasonPhrase;
                    Assert.assertEquals((String)assertMessageForBadMessage, (Object)("authorization failed for " + forUrl + ", status: 403" + reasonPhrase), (Object)e.getMessage());
                    break;
                }
                default: {
                    String statusCodeStr;
                    Assert.assertTrue((String)"transfer failures should at least be wrapped in a TransferFailedException", (boolean)(e instanceof TransferFailedException));
                    Assert.assertTrue((String)("message should always include url tried: " + e.getMessage()), (boolean)e.getMessage().startsWith("transfer failed for " + forUrl));
                    String string = statusCodeStr = forStatusCode == -1 ? "" : ", status: " + forStatusCode;
                    if (forStatusCode != -1) {
                        String reasonPhrase;
                        Assert.assertTrue((String)"if there was a response status line, the status code should be >= 400", (forStatusCode >= 400 ? 1 : 0) != 0);
                        if (e.getMessage().length() > ("transfer failed for " + forUrl).length()) {
                            Assert.assertTrue((String)("message should include url and status code: " + e.getMessage()), (boolean)e.getMessage().startsWith("transfer failed for " + forUrl + statusCodeStr));
                        }
                        String string2 = reasonPhrase = forReasonPhrase == null ? "" : " " + forReasonPhrase;
                        if (reasonPhrase.length() > 0 && e.getMessage().length() > ("transfer failed for " + forUrl + statusCodeStr).length()) {
                            Assert.assertTrue((String)("message should include url and status code and reason phrase: " + e.getMessage()), (boolean)e.getMessage().startsWith("transfer failed for " + forUrl + statusCodeStr + reasonPhrase));
                        }
                    }
                    break;
                }
            }
        }
        catch (AssertionError assertionError) {
            LOGGER.error("Exception which failed assertions: ", (Throwable)e);
            throw assertionError;
        }
    }
}

