/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.fixture;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.maven.wagon.tck.http.util.TestUtil;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFixture {
    private static Logger logger = LoggerFactory.getLogger(ServerFixture.class);
    public static final String SERVER_ROOT_RESOURCE_PATH = "default-server-root";
    public static final String SERVER_SSL_KEYSTORE_RESOURCE_PATH = "ssl/keystore";
    public static final String SERVER_SSL_KEYSTORE_PASSWORD = "wagonhttp";
    public static final String SERVER_HOST = "localhost";
    private final Server server = new Server();
    private ServerConnector serverConnector;
    private final WebAppContext webappContext;
    private final HashLoginService loginService;
    private final ConstraintSecurityHandler securityHandler;
    private int filterCount = 0;
    private int httpPort;

    public ServerFixture(boolean ssl) throws URISyntaxException, IOException {
        if (ssl) {
            String keystore = TestUtil.getResource(SERVER_SSL_KEYSTORE_RESOURCE_PATH).getAbsolutePath();
            LoggerFactory.getLogger(ServerFixture.class).info("TCK Keystore path: " + keystore);
            System.setProperty("javax.net.ssl.keyStore", keystore);
            System.setProperty("javax.net.ssl.trustStore", keystore);
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(keystore);
            sslContextFactory.setKeyStorePassword(SERVER_SSL_KEYSTORE_PASSWORD);
            sslContextFactory.setKeyManagerPassword(SERVER_SSL_KEYSTORE_PASSWORD);
            this.serverConnector = new ServerConnector(this.server, sslContextFactory);
            this.server.addConnector((Connector)this.serverConnector);
        } else {
            this.serverConnector = new ServerConnector(this.server);
            this.serverConnector.setHost(SERVER_HOST);
            this.server.addConnector((Connector)this.serverConnector);
        }
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"allowed"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/protected/*");
        this.securityHandler = new ConstraintSecurityHandler();
        this.loginService = new HashLoginService("Test Server");
        this.securityHandler.setLoginService((LoginService)this.loginService);
        this.securityHandler.setConstraintMappings(new ConstraintMapping[]{cm});
        this.webappContext = new WebAppContext();
        this.webappContext.setContextPath("/");
        File base = TestUtil.getResource(SERVER_ROOT_RESOURCE_PATH);
        logger.info("docroot: " + base);
        this.webappContext.setWar(base.getAbsolutePath());
        this.webappContext.setHandler((Handler)this.securityHandler);
        SessionHandler sessionHandler = this.webappContext.getSessionHandler();
        ((AbstractSessionManager)sessionHandler.getSessionManager()).setUsingCookies(false);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.webappContext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
    }

    public void addFilter(String pathSpec, Filter filter) {
        String name = "filter" + this.filterCount++;
        FilterMapping fm = new FilterMapping();
        fm.setPathSpec(pathSpec);
        fm.setFilterName(name);
        FilterHolder fh = new FilterHolder(filter);
        fh.setName(name);
        this.webappContext.getServletHandler().addFilter(fh, fm);
    }

    public void addServlet(String pathSpec, Servlet servlet) {
        this.webappContext.getServletHandler().addServletWithMapping(new ServletHolder(servlet), pathSpec);
    }

    public void addUser(String user, String password) {
        this.loginService.putUser(user, (Credential)new Password(password), new String[]{"allowed"});
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getWebappContext() {
        return this.webappContext;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void start() throws Exception {
        int total;
        if (this.server.isStarted() || this.server.isRunning()) {
            return;
        }
        this.server.start();
        for (total = 0; total < 3000 && !this.server.isStarted(); total += 10) {
            this.server.wait(10L);
        }
        if (!this.server.isStarted()) {
            throw new IllegalStateException("Server didn't start in: " + total + "ms.");
        }
        this.httpPort = this.serverConnector.getLocalPort();
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

