/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.fixture;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(LatencyServlet.class);
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 32;
    private final int latencyMs;

    public LatencyServlet(int latencyMs) {
        this.latencyMs = latencyMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.latencyMs < 0) {
            logger.info("Starting infinite wait.");
            LatencyServlet latencyServlet = this;
            synchronized (latencyServlet) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        String path = req.getPathInfo();
        String realPath = this.getServletContext().getRealPath(path);
        File f = new File(realPath);
        FileInputStream in = null;
        long total = 0L;
        long start = System.currentTimeMillis();
        try {
            int read;
            in = new FileInputStream(f);
            ServletOutputStream out = resp.getOutputStream();
            logger.info("Starting high-latency transfer. This should take about " + (f.length() / 32L * (long)this.latencyMs / 1000L + (long)(this.latencyMs / 1000)) + " seconds.");
            byte[] buf = new byte[32];
            while ((read = in.read(buf)) > -1) {
                try {
                    Thread.sleep(this.latencyMs);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                logger.info("Writing bytes " + total + "-" + (total + (long)read - 1L) + " of " + f.length() + ". Elapsed time so far: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
                out.write(buf, 0, read);
                total += (long)read;
            }
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        logger.info("High-latency transfer done in " + (System.currentTimeMillis() - start) + "ms");
    }
}

