/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.fixture;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.apache.maven.wagon.tck.http.util.TestUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;

public class ServerFixture {
    private static Logger logger = Logger.getLogger(ServerFixture.class);
    public static final String SERVER_ROOT_RESOURCE_PATH = "default-server-root";
    public static final String SERVER_SSL_KEYSTORE_RESOURCE_PATH = "ssl/keystore";
    public static final String SERVER_SSL_KEYSTORE_PASSWORD = "wagonhttp";
    public static final String SERVER_HOST = "localhost";
    private final Server server = new Server();
    private final WebAppContext webappContext;
    private final HashUserRealm securityRealm;
    private final SecurityHandler securityHandler;
    private int filterCount = 0;
    private int httpPort;

    public ServerFixture(boolean ssl) throws URISyntaxException, IOException {
        SslSocketConnector connector;
        if (ssl) {
            connector = new SslSocketConnector();
            String keystore = TestUtil.getResource(SERVER_SSL_KEYSTORE_RESOURCE_PATH).getAbsolutePath();
            Logger.getLogger(ServerFixture.class).info((Object)("TCK Keystore path: " + keystore));
            System.setProperty("javax.net.ssl.keyStore", keystore);
            System.setProperty("javax.net.ssl.trustStore", keystore);
            connector.setKeystore(keystore);
            connector.setPassword(SERVER_SSL_KEYSTORE_PASSWORD);
            connector.setKeyPassword(SERVER_SSL_KEYSTORE_PASSWORD);
            this.server.addConnector((Connector)connector);
        } else {
            connector = new SelectChannelConnector();
            connector.setHost(SERVER_HOST);
            this.server.addConnector((Connector)connector);
        }
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"allowed"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/protected/*");
        this.securityHandler = new SecurityHandler();
        this.securityRealm = new HashUserRealm("Test Server");
        this.securityHandler.setUserRealm((UserRealm)this.securityRealm);
        this.securityHandler.setConstraintMappings(new ConstraintMapping[]{cm});
        this.webappContext = new WebAppContext();
        this.webappContext.setContextPath("/");
        File base = TestUtil.getResource(SERVER_ROOT_RESOURCE_PATH);
        logger.info((Object)("docroot: " + base));
        this.webappContext.setWar(base.getAbsolutePath());
        this.webappContext.addHandler((Handler)this.securityHandler);
        SessionHandler sessionHandler = this.webappContext.getSessionHandler();
        ((AbstractSessionManager)sessionHandler.getSessionManager()).setUsingCookies(false);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.webappContext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
    }

    public void addFilter(String pathSpec, Filter filter) {
        String name = "filter" + this.filterCount++;
        FilterMapping fm = new FilterMapping();
        fm.setPathSpec(pathSpec);
        fm.setFilterName(name);
        FilterHolder fh = new FilterHolder(filter);
        fh.setName(name);
        this.webappContext.getServletHandler().addFilter(fh, fm);
    }

    public void addServlet(String pathSpec, Servlet servlet) {
        this.webappContext.getServletHandler().addServletWithMapping(new ServletHolder(servlet), pathSpec);
    }

    public void addUser(String user, String password) {
        this.securityRealm.put((Object)user, (Object)password);
        this.securityRealm.addUserToRole(user, "allowed");
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getWebappContext() {
        return this.webappContext;
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void start() throws Exception {
        int total;
        if (this.server.isStarted() || this.server.isRunning()) {
            return;
        }
        this.server.start();
        for (total = 0; total < 3000 && !this.server.isStarted(); total += 10) {
            this.server.wait(10L);
        }
        if (!this.server.isStarted()) {
            throw new IllegalStateException("Server didn't start in: " + total + "ms.");
        }
        this.httpPort = this.server.getConnectors()[0].getLocalPort();
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

