/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.tck.http.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.codehaus.plexus.util.IOUtil;

public final class TestUtil {
    private static Logger logger = Logger.getLogger(TestUtil.class);
    private static final Map<String, File> bases = new HashMap<String, File>();

    private TestUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getResource(String path) throws URISyntaxException, IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
        if (resource == null) {
            throw new IllegalStateException("Cannot find classpath resource: " + path);
        }
        if (resource.getProtocol().startsWith("jar")) {
            int endIdx;
            String url = resource.toExternalForm();
            int startIdx = url.lastIndexOf(58) + 1;
            File base = bases.get(url = url.substring(startIdx, endIdx = url.indexOf("!")));
            if (base == null) {
                File urlFile = new File(url);
                base = new File("target/tck-resources/" + urlFile.getName());
                base.getParentFile().mkdirs();
                logger.info((Object)("unpacking test resources in jar: " + url));
                JarFile jf = null;
                try {
                    jf = new JarFile(urlFile);
                    InputStream in = null;
                    FileOutputStream out = null;
                    Enumeration<JarEntry> en = jf.entries();
                    while (en.hasMoreElements()) {
                        JarEntry je = en.nextElement();
                        File target = new File(base, je.getName()).getAbsoluteFile();
                        if (je.isDirectory()) {
                            target.mkdirs();
                            continue;
                        }
                        target.getParentFile().mkdirs();
                        try {
                            in = jf.getInputStream(je);
                            out = new FileOutputStream(target);
                            IOUtil.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close((InputStream)in);
                            IOUtil.close(out);
                            throw throwable;
                        }
                        IOUtil.close((InputStream)in);
                        IOUtil.close((OutputStream)out);
                    }
                    bases.put(url, base);
                }
                finally {
                    if (jf != null) {
                        try {
                            jf.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            return new File(base, path);
        }
        return new File(resource.toURI().normalize());
    }
}

