/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.Streams;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusTestCase;

public abstract class CommandExecutorTestCase
extends PlexusTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorInCommandExecuted() throws Exception {
        CommandExecutor exec = (CommandExecutor)this.lookup(CommandExecutor.ROLE);
        Repository repository = this.getTestRepository();
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setUserName(System.getProperty("user.name"));
        exec.connect(repository, authenticationInfo);
        try {
            exec.executeCommand("fail");
            CommandExecutorTestCase.fail((String)"Command should have failed");
        }
        catch (CommandExecutionException e) {
            CommandExecutorTestCase.assertTrue((boolean)e.getMessage().trim().endsWith("fail: command not found"));
        }
        finally {
            exec.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnoreFailuresInCommandExecuted() throws Exception {
        CommandExecutor exec = (CommandExecutor)this.lookup(CommandExecutor.ROLE);
        Repository repository = this.getTestRepository();
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setUserName(System.getProperty("user.name"));
        exec.connect(repository, authenticationInfo);
        try {
            Streams streams = exec.executeCommand("fail", true);
            CommandExecutorTestCase.assertTrue((streams.getErr().length() > 0 ? 1 : 0) != 0);
        }
        finally {
            exec.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteSuccessfulCommand() throws Exception {
        CommandExecutor exec = (CommandExecutor)this.lookup(CommandExecutor.ROLE);
        Repository repository = this.getTestRepository();
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setUserName(System.getProperty("user.name"));
        exec.connect(repository, authenticationInfo);
        try {
            exec.executeCommand("ls");
        }
        finally {
            exec.disconnect();
        }
    }

    protected abstract Repository getTestRepository();
}

