/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;

public abstract class WagonTestCase
extends PlexusTestCase {
    protected static String POM = "pom.xml";
    protected Repository localRepository;
    protected Repository testRepository;
    protected String localRepositoryPath;
    protected File sourceFile;
    protected File destFile;
    protected String resource;
    protected File artifactSourceFile;
    protected File artifactDestFile;
    protected ChecksumObserver checksumObserver;

    protected void setUp() throws Exception {
        this.checksumObserver = new ChecksumObserver();
        super.setUp();
    }

    protected abstract String getTestRepositoryUrl() throws IOException;

    protected abstract String getProtocol();

    protected void setupRepositories() throws Exception {
        this.resource = "test-resource.txt";
        this.testRepository = new Repository();
        this.testRepository.setUrl(this.getTestRepositoryUrl());
        this.testRepository.setPermissions(this.getPermissions());
        this.localRepositoryPath = FileTestUtils.createDir("local-repository").getPath();
        this.localRepository = this.createFileRepository("file://" + this.localRepositoryPath);
        this.message("Local repository: " + this.localRepository);
        File f = new File(this.localRepositoryPath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    protected void customizeContext() throws Exception {
        this.getContainer().addContextValue((Object)"test.repository", (Object)this.localRepositoryPath);
    }

    protected void setupWagonTestingFixtures() throws Exception {
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
    }

    protected AuthenticationInfo getAuthInfo() {
        return new AuthenticationInfo();
    }

    protected RepositoryPermissions getPermissions() {
        return new RepositoryPermissions();
    }

    protected Wagon getWagon() throws Exception {
        Wagon wagon = (Wagon)this.lookup(Wagon.ROLE, this.getProtocol());
        Debug debug = new Debug();
        wagon.addSessionListener((SessionListener)debug);
        wagon.addTransferListener((TransferListener)debug);
        return wagon;
    }

    private void message(String message) {
        System.out.println(message);
    }

    public void testWagon() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.fileRoundTripTesting();
        this.tearDownWagonTestingFixtures();
    }

    public void testWagonPutDirectory() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        Wagon wagon = this.getWagon();
        if (wagon.supportsDirectoryCopy()) {
            this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "directory-copy");
            this.writeTestFile("test-resource-1.txt");
            this.writeTestFile("a/test-resource-2.txt");
            this.writeTestFile("a/b/test-resource-3.txt");
            this.writeTestFile("c/test-resource-4.txt");
            wagon.connect(this.testRepository, this.getAuthInfo());
            wagon.putDirectory(this.sourceFile, "directory-copy");
            this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            this.destFile.deleteOnExit();
            wagon.get("directory-copy/test-resource-1.txt", this.destFile);
            wagon.get("directory-copy/a/test-resource-2.txt", this.destFile);
            wagon.get("directory-copy/a/b/test-resource-3.txt", this.destFile);
            wagon.get("directory-copy/c/test-resource-4.txt", this.destFile);
            wagon.disconnect();
        }
        this.tearDownWagonTestingFixtures();
    }

    private void writeTestFile(String child) throws IOException {
        File dir = new File(this.sourceFile, child);
        dir.getParentFile().mkdirs();
        FileUtils.fileWrite((String)dir.getAbsolutePath(), (String)child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailedGet() throws Exception {
        this.setupRepositories();
        this.setupWagonTestingFixtures();
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        try {
            wagon.get("fubar.txt", this.destFile);
            Assert.fail((String)"File was found when it sohuldn't have been");
        }
        catch (ResourceDoesNotExistException e) {
            Assert.assertTrue((boolean)true);
        }
        finally {
            wagon.removeTransferListener((TransferListener)this.checksumObserver);
            wagon.disconnect();
            this.tearDownWagonTestingFixtures();
        }
    }

    protected void putFile() throws Exception {
        this.message("Putting test artifact: " + this.resource + " into test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.sourceFile = new File(FileTestUtils.getTestOutputDir(), "test-resource.txt");
        FileUtils.fileWrite((String)this.sourceFile.getAbsolutePath(), (String)"test-resource.txt\n");
        wagon.put(this.sourceFile, this.resource);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void getFile() throws Exception {
        this.message("Getting test artifact from test repository " + this.testRepository);
        Wagon wagon = this.getWagon();
        wagon.addTransferListener((TransferListener)this.checksumObserver);
        wagon.connect(this.testRepository, this.getAuthInfo());
        this.destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
        this.destFile.deleteOnExit();
        wagon.get(this.resource, this.destFile);
        wagon.removeTransferListener((TransferListener)this.checksumObserver);
        wagon.disconnect();
    }

    protected void fileRoundTripTesting() throws Exception {
        this.message("File round trip testing ...");
        this.putFile();
        Assert.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        Assert.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        this.checksumObserver = new ChecksumObserver();
        this.getFile();
        Assert.assertNotNull((String)"check checksum is not null", (Object)this.checksumObserver.getActualChecksum());
        Assert.assertEquals((String)"compare checksums", (String)"6b144b7285ffd6b0bc8300da162120b9", (String)this.checksumObserver.getActualChecksum());
        String sourceContent = FileUtils.fileRead((File)this.sourceFile);
        String destContent = FileUtils.fileRead((File)this.destFile);
        Assert.assertEquals((String)sourceContent, (String)destContent);
    }

    protected Repository createFileRepository(String url) {
        File path = new File(url.substring(7));
        path.mkdirs();
        Repository repository = new Repository();
        repository.setUrl(url);
        return repository;
    }
}

