/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shadefire.org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.shadefire.org.codehaus.plexus.util.MatchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchPatterns {
    private final MatchPattern[] patterns;

    private MatchPatterns(MatchPattern[] patterns) {
        this.patterns = patterns;
    }

    public boolean matches(String name, boolean isCaseSensitive) {
        String[] tokenized = MatchPattern.tokenizePathToString(name, File.separator);
        for (MatchPattern pattern : this.patterns) {
            if (!pattern.matchPath(name, tokenized, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesPatternStart(String name, boolean isCaseSensitive) {
        for (MatchPattern includesPattern : this.patterns) {
            if (!includesPattern.matchPatternStart(name, isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static MatchPatterns from(String ... sources) {
        int length = sources.length;
        MatchPattern[] result = new MatchPattern[length];
        for (int i = 0; i < length; ++i) {
            result[i] = MatchPattern.fromString(sources[i]);
        }
        return new MatchPatterns(result);
    }

    public static MatchPatterns from(Iterable<String> strings) {
        return new MatchPatterns(MatchPatterns.getMatchPatterns(strings));
    }

    private static MatchPattern[] getMatchPatterns(Iterable<String> items) {
        ArrayList<MatchPattern> result = new ArrayList<MatchPattern>();
        for (String string : items) {
            result.add(MatchPattern.fromString(string));
        }
        return result.toArray(new MatchPattern[result.size()]);
    }
}

