/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.junit4.JUnit4TestSetReporter;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.testset.AbstractTestSet;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestSet
extends AbstractTestSet {
    private final List<RunListener> customRunListeners;

    protected JUnit4TestSet(Class testClass, List<RunListener> customRunListeners) {
        super(testClass);
        this.customRunListeners = customRunListeners;
    }

    protected JUnit4TestSet(Class testClass) {
        super(testClass);
        this.customRunListeners = new ArrayList<RunListener>();
    }

    public void execute(ReporterManager reportManager, ClassLoader loader) throws TestSetFailedException {
        ArrayList<RunListener> listeners = new ArrayList<RunListener>();
        listeners.add(new JUnit4TestSetReporter(this.getTestClass(), reportManager));
        listeners.addAll(this.customRunListeners);
        JUnit4TestSet.execute(this.getTestClass(), listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Class testClass, List<RunListener> runListeners) throws TestSetFailedException {
        RunNotifier fNotifier = new RunNotifier();
        for (RunListener listener : runListeners) {
            fNotifier.addListener(listener);
        }
        try {
            JUnit4TestSet.execute(testClass, fNotifier);
        }
        finally {
            for (RunListener listener : runListeners) {
                fNotifier.removeListener(listener);
            }
        }
    }

    public static void execute(Class testClass, RunNotifier fNotifier) throws TestSetFailedException {
        Runner junitTestRunner = Request.aClass((Class)testClass).getRunner();
        junitTestRunner.run(fNotifier);
    }
}

