/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.report.ReporterConfiguration;
import org.apache.maven.surefire.api.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.api.testset.RunOrderParameters;
import org.apache.maven.surefire.api.testset.TestArtifactInfo;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.booter.TypeEncodedValue;

public class ProviderConfiguration {
    private final DirectoryScannerParameters dirScannerParams;
    private final ReporterConfiguration reporterConfiguration;
    private final TestArtifactInfo testArtifact;
    private final TestRequest testSuiteDefinition;
    private final RunOrderParameters runOrderParameters;
    private final Map<String, String> providerProperties;
    private final TypeEncodedValue forkTestSet;
    private final boolean readTestsFromInStream;
    private final List<CommandLineOption> mainCliOptions;
    private final int skipAfterFailureCount;
    private final Shutdown shutdown;
    private final Integer systemExitTimeout;

    public ProviderConfiguration(DirectoryScannerParameters directoryScannerParameters, RunOrderParameters runOrderParameters, ReporterConfiguration reporterConfiguration, TestArtifactInfo testArtifact, TestRequest testSuiteDefinition, Map<String, String> providerProperties, TypeEncodedValue typeEncodedTestSet, boolean readTestsFromInStream, List<CommandLineOption> mainCliOptions, int skipAfterFailureCount, Shutdown shutdown, Integer systemExitTimeout) {
        this.runOrderParameters = runOrderParameters;
        this.providerProperties = providerProperties;
        this.reporterConfiguration = reporterConfiguration;
        this.testArtifact = testArtifact;
        this.testSuiteDefinition = testSuiteDefinition;
        this.dirScannerParams = directoryScannerParameters;
        this.forkTestSet = typeEncodedTestSet;
        this.readTestsFromInStream = readTestsFromInStream;
        this.mainCliOptions = mainCliOptions;
        this.skipAfterFailureCount = skipAfterFailureCount;
        this.shutdown = shutdown;
        this.systemExitTimeout = systemExitTimeout;
    }

    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    public File getBaseDir() {
        return this.dirScannerParams.getTestClassesDirectory();
    }

    public DirectoryScannerParameters getDirScannerParams() {
        return this.dirScannerParams;
    }

    @Deprecated
    public List getIncludes() {
        return this.dirScannerParams.getIncludes();
    }

    @Deprecated
    public List getExcludes() {
        return this.dirScannerParams.getExcludes();
    }

    public TestArtifactInfo getTestArtifact() {
        return this.testArtifact;
    }

    public TestRequest getTestSuiteDefinition() {
        return this.testSuiteDefinition;
    }

    public Map<String, String> getProviderProperties() {
        return this.providerProperties;
    }

    public TypeEncodedValue getTestForFork() {
        return this.forkTestSet;
    }

    public RunOrderParameters getRunOrderParameters() {
        return this.runOrderParameters;
    }

    public boolean isReadTestsFromInStream() {
        return this.readTestsFromInStream;
    }

    public List<CommandLineOption> getMainCliOptions() {
        return this.mainCliOptions;
    }

    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    public Integer getSystemExitTimeout() {
        return this.systemExitTimeout;
    }

    public long systemExitTimeout(long fallback) {
        return this.systemExitTimeout == null || this.systemExitTimeout < 0 ? fallback : (long)this.systemExitTimeout.intValue();
    }
}

