/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.apache.maven.surefire.api.runorder.RunEntryStatisticsMap;
import org.apache.maven.surefire.api.testset.RunOrderParameters;
import org.apache.maven.surefire.api.util.RunOrder;
import org.apache.maven.surefire.api.util.RunOrderCalculator;
import org.apache.maven.surefire.api.util.TestsToRun;

public class DefaultRunOrderCalculator
implements RunOrderCalculator {
    private final Comparator<Class> sortOrder;
    private final RunOrder[] runOrder;
    private final RunOrderParameters runOrderParameters;
    private final int threadCount;
    private final Random random;

    public DefaultRunOrderCalculator(RunOrderParameters runOrderParameters, int threadCount) {
        this.runOrderParameters = runOrderParameters;
        this.threadCount = threadCount;
        this.runOrder = runOrderParameters.getRunOrder();
        this.sortOrder = this.runOrder.length > 0 ? this.getSortOrderComparator(this.runOrder[0]) : null;
        Long runOrderRandomSeed = runOrderParameters.getRunOrderRandomSeed();
        if (runOrderRandomSeed == null) {
            runOrderRandomSeed = System.nanoTime();
            runOrderParameters.setRunOrderRandomSeed(runOrderRandomSeed);
        }
        this.random = new Random(runOrderRandomSeed);
    }

    @Override
    public TestsToRun orderTestClasses(TestsToRun scannedClasses) {
        ArrayList result = new ArrayList(512);
        for (Class<?> scannedClass : scannedClasses) {
            result.add(scannedClass);
        }
        this.orderTestClasses(result, this.runOrder.length != 0 ? this.runOrder[0] : null);
        return new TestsToRun(new LinkedHashSet(result));
    }

    private void orderTestClasses(List<Class<?>> testClasses, RunOrder runOrder) {
        if (RunOrder.RANDOM.equals(runOrder)) {
            Collections.shuffle(testClasses, this.random);
        } else if (RunOrder.FAILEDFIRST.equals(runOrder)) {
            RunEntryStatisticsMap stat = RunEntryStatisticsMap.fromFile(this.runOrderParameters.getRunStatisticsFile());
            List<Class<?>> prioritized = stat.getPrioritizedTestsByFailureFirst(testClasses);
            testClasses.clear();
            testClasses.addAll(prioritized);
        } else if (RunOrder.BALANCED.equals(runOrder)) {
            RunEntryStatisticsMap stat = RunEntryStatisticsMap.fromFile(this.runOrderParameters.getRunStatisticsFile());
            List<Class<?>> prioritized = stat.getPrioritizedTestsClassRunTime(testClasses, this.threadCount);
            testClasses.clear();
            testClasses.addAll(prioritized);
        } else if (this.sortOrder != null) {
            Collections.sort(testClasses, this.sortOrder);
        }
    }

    private Comparator<Class> getSortOrderComparator(RunOrder runOrder) {
        if (RunOrder.ALPHABETICAL.equals(runOrder)) {
            return this.getAlphabeticalComparator();
        }
        if (RunOrder.REVERSE_ALPHABETICAL.equals(runOrder)) {
            return this.getReverseAlphabeticalComparator();
        }
        if (RunOrder.HOURLY.equals(runOrder)) {
            int hour = Calendar.getInstance().get(11);
            return hour % 2 == 0 ? this.getAlphabeticalComparator() : this.getReverseAlphabeticalComparator();
        }
        return null;
    }

    private Comparator<Class> getReverseAlphabeticalComparator() {
        return new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o2.getName().compareTo(o1.getName());
            }
        };
    }

    private Comparator<Class> getAlphabeticalComparator() {
        return new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }
}

