/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class NestedRuntimeException
extends RuntimeException {
    private Throwable cause;

    public NestedRuntimeException(String msg, Throwable ex) {
        super(msg);
        this.cause = ex;
    }

    public NestedRuntimeException(Throwable ex) {
        this.cause = ex;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        if (this.getCause() == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is " + this.getCause().getClass().getName() + ": " + this.getCause().getMessage();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getCause() == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.getCause().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getCause() == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.getCause().printStackTrace(pw);
        }
    }

    public Throwable getRootCause() {
        Throwable cause = this.getCause();
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)cause).getRootCause();
        }
        return cause;
    }

    public boolean contains(Class exClass) {
        if (exClass == null) {
            return false;
        }
        if (exClass.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)cause).contains(exClass);
        }
        return cause != null && exClass.isInstance(cause);
    }
}

