/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.surefire.report.StackTraceWriter;

public class ReportEntry {
    private Object source;
    private String name;
    private String group;
    private String message;
    private StackTraceWriter stackTraceWriter;

    public ReportEntry() {
    }

    public ReportEntry(Object source, String name, String message) {
        this(source, name, null, message);
    }

    public ReportEntry(Object source, String name, String group, String message) {
        this(source, name, group, message, null);
    }

    public ReportEntry(Object source, String name, String message, StackTraceWriter stackTraceWriter) {
        this(source, name, null, message, stackTraceWriter);
    }

    public ReportEntry(Object source, String name, String group, String message, StackTraceWriter stackTraceWriter) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.setSource(source);
        this.setName(name);
        this.setGroup(group);
        this.setMessage(message);
        this.setStackTraceWriter(stackTraceWriter);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStackTraceWriter(StackTraceWriter stackTraceWriter) {
        this.stackTraceWriter = stackTraceWriter;
    }

    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportEntry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ReportEntry rhs = (ReportEntry)obj;
        return new EqualsBuilder().append(this.getSource(), rhs.getSource()).append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getGroup(), (Object)rhs.getGroup()).append((Object)this.getMessage(), (Object)rhs.getMessage()).append((Object)this.getStackTraceWriter(), (Object)rhs.getStackTraceWriter()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("source", this.getSource()).append("name", (Object)this.getName()).append("group", (Object)this.getGroup()).append("message", (Object)this.getMessage()).append("stackTraceWriter", (Object)this.getStackTraceWriter()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(5897, 6653).append(this.getSource()).append((Object)this.getName()).append((Object)this.getGroup()).append((Object)this.getMessage()).append((Object)this.getStackTraceWriter()).toHashCode();
    }
}

