/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.extensions;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.extensions.CloseableDaemonThread;
import org.apache.maven.surefire.extensions.CommandReader;
import org.apache.maven.surefire.stream.CommandEncoder;

public class StreamFeeder
extends CloseableDaemonThread {
    private final WritableByteChannel channel;
    private final CommandReader commandReader;
    private final ConsoleLogger logger;
    private volatile boolean disabled;
    private volatile Throwable exception;

    public StreamFeeder(@Nonnull String threadName, @Nonnull WritableByteChannel channel, @Nonnull CommandReader commandReader, @Nonnull ConsoleLogger logger) {
        super(threadName);
        this.channel = channel;
        this.commandReader = commandReader;
        this.logger = logger;
    }

    public void run() {
        try (CommandEncoder encoder2 = new CommandEncoder(this.channel);){
            Command cmd;
            block21: while ((cmd = this.commandReader.readNextCommand()) != null) {
                if (this.disabled) continue;
                switch (cmd.getCommandType()) {
                    case RUN_CLASS: {
                        encoder2.sendRunClass(cmd.getData());
                        continue block21;
                    }
                    case TEST_SET_FINISHED: {
                        encoder2.sendTestSetFinished();
                        continue block21;
                    }
                    case SKIP_SINCE_NEXT_TEST: {
                        encoder2.sendSkipSinceNextTest();
                        continue block21;
                    }
                    case SHUTDOWN: {
                        encoder2.sendShutdown(cmd.getData());
                        continue block21;
                    }
                    case NOOP: {
                        encoder2.sendNoop();
                        continue block21;
                    }
                    case BYE_ACK: {
                        encoder2.sendByeAck();
                        continue block21;
                    }
                }
                this.logger.error("Unknown enum " + cmd.getCommandType().name());
            }
        }
        catch (ClosedChannelException encoder2) {
        }
        catch (IOException | NonWritableChannelException e) {
            this.exception = e.getCause() == null ? e : e.getCause();
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void disable() {
        this.disabled = true;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

