/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.internal.StringUtils;

public class FileReporter {
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final Charset encoding;

    public FileReporter(File reportsDirectory, String reportNameSuffix, Charset encoding) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
        this.encoding = encoding;
    }

    private PrintWriter testSetStarting(ReportEntry report) {
        File reportFile = FileReporter.getReportFile(this.reportsDirectory, report.getName(), this.reportNameSuffix, ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try {
            OutputStreamWriter encodedStream = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), this.encoding);
            PrintWriter writer = new PrintWriter(new BufferedWriter(encodedStream, 16384));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            return writer;
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), (Exception)e);
        }
    }

    static File getReportFile(File reportsDirectory, String reportEntryName, String reportNameSuffix, String fileExtension) {
        String fileName = reportEntryName + (StringUtils.isNotBlank((String)reportNameSuffix) ? "-" + reportNameSuffix : "") + fileExtension;
        return new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(fileName));
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        try (PrintWriter writer = this.testSetStarting((ReportEntry)report);){
            writer.println(testSetStats.getTestSetSummary(report));
            for (String testResult : testResults) {
                writer.println(testResult);
            }
        }
    }
}

