/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.lazytestprovider;

import java.io.IOException;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractForkInputStream;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessCommand;

public abstract class AbstractCommandStream
extends AbstractForkInputStream {
    private byte[] currentBuffer;
    private int currentPos;
    private volatile MasterProcessCommand lastCommand;

    protected abstract boolean isClosed();

    protected boolean canContinue() {
        return !this.isClosed();
    }

    protected void beforeNextCommand() throws IOException {
    }

    protected abstract Command nextCommand();

    protected final void invalidateInternalBuffer() {
        this.currentBuffer = null;
        this.currentPos = 0;
    }

    protected final MasterProcessCommand getLastCommand() {
        return this.lastCommand;
    }

    @Override
    public int read() throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        byte[] buffer = this.currentBuffer;
        if (buffer == null) {
            this.tryFlush();
            if (!this.canContinue()) {
                this.close();
                return -1;
            }
            this.beforeNextCommand();
            if (this.isClosed()) {
                return -1;
            }
            Command cmd = this.nextCommand();
            this.lastCommand = cmd.getCommandType();
            buffer = this.lastCommand.hasDataType() ? this.lastCommand.encode(cmd.getData()) : this.lastCommand.encode();
        }
        int b = buffer[this.currentPos++] & 0xFF;
        if (this.currentPos == buffer.length) {
            buffer = null;
            this.currentPos = 0;
        }
        this.currentBuffer = buffer;
        return b;
    }
}

