/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.surefire.ClasspathCache;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.InPluginVMSurefireStarter;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.plugin.surefire.booterclient.ProviderDetector;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.util.DependencyScanner;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.shade.org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.RunOrder;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private final ProviderDetector providerDetector = new ProviderDetector();
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Deprecated
    @Parameter(property="maven.test.skip.exec")
    protected boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    protected File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testClassesDirectory;
    @Parameter(property="maven.test.dependency.excludes")
    private String[] classpathDependencyExcludes;
    @Parameter(defaultValue="")
    private String classpathDependencyScopeExclude;
    @Parameter(property="maven.test.additionalClasspath")
    private String[] additionalClasspathElements;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", required=true)
    private File testSourceDirectory;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Deprecated
    @Parameter
    private Properties systemProperties;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter
    private File systemPropertiesFile;
    @Parameter
    private Properties properties;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="project.artifactMap", readonly=true, required=true)
    private Map<String, Artifact> projectArtifactMap;
    @Parameter(property="surefire.reportNameSuffix", defaultValue="")
    private String reportNameSuffix;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    private boolean redirectTestOutputToFile;
    @Parameter(property="failIfNoTests")
    private Boolean failIfNoTests;
    @Parameter(property="forkMode", defaultValue="once")
    private String forkMode;
    @Parameter(property="tempDir", defaultValue="surefire")
    private String tempDir;
    @Parameter(property="jvm")
    private String jvm;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="basedir")
    private File workingDirectory;
    @Parameter(property="childDelegation", defaultValue="false")
    private boolean childDelegation;
    @Parameter(property="groups")
    private String groups;
    @Parameter(property="excludedGroups")
    private String excludedGroups;
    @Parameter(property="junitArtifactName", defaultValue="junit:junit")
    private String junitArtifactName;
    @Parameter(property="testNGArtifactName", defaultValue="org.testng:testng")
    private String testNGArtifactName;
    @Parameter(property="threadCount")
    private int threadCount;
    @Parameter(property="forkCount", defaultValue="1")
    private String forkCount;
    @Parameter(property="reuseForks", defaultValue="true")
    private boolean reuseForks;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    private boolean perCoreThreadCount;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    private boolean useUnlimitedThreads;
    @Parameter(property="parallel")
    private String parallel;
    @Parameter(property="parallelOptimized", defaultValue="true")
    private boolean parallelOptimized;
    @Parameter(property="threadCountSuites", defaultValue="0")
    private int threadCountSuites;
    @Parameter(property="threadCountClasses", defaultValue="0")
    private int threadCountClasses;
    @Parameter(property="threadCountMethods", defaultValue="0")
    private int threadCountMethods;
    @Parameter(property="trimStackTrace", defaultValue="true")
    private boolean trimStackTrace;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactMetadataSource metadataSource;
    @Parameter(property="disableXmlReport", defaultValue="false")
    private boolean disableXmlReport;
    @Parameter(property="enableAssertions", defaultValue="true")
    private boolean enableAssertions;
    @Component
    private MavenSession session;
    @Parameter(property="objectFactory")
    private String objectFactory;
    @Parameter(defaultValue="${session.parallel}", readonly=true)
    private Boolean parallelMavenExecution;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File projectBuildDirectory;
    @Parameter(property="dependenciesToScan")
    private String[] dependenciesToScan;
    @Component
    private ToolchainManager toolchainManager;
    private Artifact surefireBooterArtifact;
    private Toolchain toolchain;
    private int effectiveForkCount = -1;
    public static final String THREAD_NUMBER_PLACEHOLDER = "${surefire.threadNumber}";
    public static final String FORK_NUMBER_PLACEHOLDER = "${surefire.forkNumber}";
    private SurefireDependencyResolver dependencyResolver;
    private TestListResolver specificTests;
    private TestListResolver includedExcludedTests;
    private List<CommandLineOption> cli;
    private volatile PluginConsoleLogger consoleLogger;

    protected abstract String getPluginName();

    protected abstract int getRerunFailingTestsCount();

    @Override
    public abstract List<String> getIncludes();

    public abstract File getIncludesFile();

    @Override
    public abstract void setIncludes(List<String> var1);

    public abstract File getExcludesFile();

    protected abstract List<File> suiteXmlFiles();

    protected abstract boolean hasSuiteXmlFiles();

    public abstract File[] getSuiteXmlFiles();

    public abstract void setSuiteXmlFiles(File[] var1);

    public abstract String getRunOrder();

    public abstract void setRunOrder(String var1);

    protected abstract void handleSummary(RunResult var1, Exception var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isSkipExecution();

    protected abstract String[] getDefaultIncludes();

    protected abstract String getReportSchemaLocation();

    private String getDefaultExcludes() {
        return "**/*$*";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cli = this.commandLineOptions();
        this.setupStuff();
        if (this.verifyParameters() && !this.hasExecutedBefore()) {
            DefaultScanResult scan = this.scanForTestClasses();
            if (!this.hasSuiteXmlFiles() && scan.isEmpty()) {
                if (this.getEffectiveFailIfNoTests()) {
                    throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
                }
                this.handleSummary(RunResult.noTestsRun(), null);
                return;
            }
            this.logReportsDirectory();
            this.executeAfterPreconditionsChecked(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final PluginConsoleLogger getConsoleLogger() {
        if (this.consoleLogger == null) {
            AbstractSurefireMojo abstractSurefireMojo = this;
            synchronized (abstractSurefireMojo) {
                if (this.consoleLogger == null) {
                    this.consoleLogger = new PluginConsoleLogger(this.getLog());
                }
            }
        }
        return this.consoleLogger;
    }

    private void setupStuff() {
        this.createDependencyResolver();
        this.surefireBooterArtifact = this.getSurefireBooterArtifact();
        this.toolchain = this.getToolchain();
    }

    private DefaultScanResult scanForTestClasses() throws MojoFailureException {
        DefaultScanResult scan = this.scanDirectories();
        DefaultScanResult scanDeps = this.scanDependencies();
        return scan.append(scanDeps);
    }

    private DefaultScanResult scanDirectories() throws MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner(this.getTestClassesDirectory(), this.getIncludedAndExcludedTests());
        return scanner.scan();
    }

    private DefaultScanResult scanDependencies() {
        if (this.getDependenciesToScan() == null) {
            return null;
        }
        try {
            List<File> dependenciesToScan = DependencyScanner.filter(this.project.getTestArtifacts(), Arrays.asList(this.getDependenciesToScan()));
            DependencyScanner scanner = new DependencyScanner(dependenciesToScan, this.getIncludedAndExcludedTests());
            return scanner.scan();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    boolean verifyParameters() throws MojoFailureException, MojoExecutionException {
        this.setProperties(new SurefireProperties(this.getProperties()));
        if (this.isSkipExecution()) {
            this.getConsoleLogger().info("Tests are skipped.");
            return false;
        }
        String jvmToUse = this.getJvm();
        if (this.toolchain != null) {
            this.getConsoleLogger().info("Toolchain in maven-" + this.getPluginName() + "-plugin: " + this.toolchain);
            if (jvmToUse != null) {
                this.getConsoleLogger().warning("Toolchains are ignored, 'executable' parameter is set to " + jvmToUse);
            }
        }
        if (!(this.getTestClassesDirectory().exists() || this.getDependenciesToScan() != null && this.getDependenciesToScan().length != 0)) {
            if (Boolean.TRUE.equals(this.getFailIfNoTests())) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getConsoleLogger().info("No tests to run.");
        } else {
            this.convertDeprecatedForkMode();
            this.ensureWorkingDirectoryExists();
            this.ensureParallelRunningCompatibility();
            this.ensureThreadCountWithPerThread();
            this.warnIfUselessUseSystemClassLoaderParameter();
            this.warnIfDefunctGroupsCombinations();
            this.warnIfRerunClashes();
            this.warnIfWrongShutdownValue();
            this.warnIfNotApplicableSkipAfterFailureCount();
            this.warnIfIllegalTempDir();
        }
        return true;
    }

    private void executeAfterPreconditionsChecked(DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        List<ProviderInfo> providers = this.createProviders();
        RunResult current = RunResult.noTestsRun();
        Throwable firstForkException = null;
        for (ProviderInfo provider : providers) {
            try {
                current = current.aggregate(this.executeProvider(provider, scanResult));
            }
            catch (SurefireBooterForkException e) {
                if (firstForkException != null) continue;
                firstForkException = e;
            }
            catch (SurefireExecutionException e) {
                if (firstForkException != null) continue;
                firstForkException = e;
            }
            catch (TestSetFailedException e) {
                if (firstForkException != null) continue;
                firstForkException = e;
            }
        }
        if (firstForkException != null) {
            current = RunResult.failure((RunResult)current, firstForkException);
        }
        this.handleSummary(current, (Exception)firstForkException);
    }

    private void createDependencyResolver() {
        this.dependencyResolver = new SurefireDependencyResolver(this.getArtifactResolver(), this.getArtifactFactory(), this.getConsoleLogger(), this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), this.getPluginName());
    }

    protected List<ProviderInfo> createProviders() throws MojoFailureException, MojoExecutionException {
        Artifact junitDepArtifact = this.getJunitDepArtifact();
        return new ProviderList(new DynamicProviderInfo(null), new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit4ProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit3ProviderInfo()).resolve();
    }

    private SurefireProperties setupProperties() {
        SurefireProperties sysProps = null;
        try {
            sysProps = SurefireProperties.loadProperties(this.systemPropertiesFile);
        }
        catch (IOException e) {
            String msg = "The system property file '" + this.systemPropertiesFile.getAbsolutePath() + "' can't be read.";
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug(msg, e);
            }
            this.getConsoleLogger().warning(msg);
        }
        SurefireProperties result = SurefireProperties.calculateEffectiveProperties(this.getSystemProperties(), this.getSystemPropertyVariables(), this.getUserProperties(), sysProps);
        result.setProperty("basedir", this.getBasedir().getAbsolutePath());
        result.setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        result.setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (this.isForking()) {
            for (Object o : result.propertiesThatCannotBeSetASystemProperties()) {
                if (this.getArgLine() != null && this.getArgLine().contains("-D" + o + "=")) continue;
                this.getConsoleLogger().warning(o + " cannot be set as system property, use <argLine>-D" + o + "=...</argLine> instead");
            }
            for (Object systemPropertyMatchingArgLine : this.systemPropertiesMatchingArgLine(result)) {
                this.getConsoleLogger().warning("The system property " + systemPropertyMatchingArgLine + " is configured twice! " + "The property appears in <argLine/> and any of <systemPropertyVariables/>, " + "<systemProperties/> or user property.");
            }
        }
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showToLog(result, this.getConsoleLogger(), "system property");
        }
        return result;
    }

    private Set<Object> systemPropertiesMatchingArgLine(SurefireProperties result) {
        HashSet<Object> intersection = new HashSet<Object>();
        if (StringUtils.isNotBlank(this.getArgLine())) {
            for (Object systemProperty : result.getStringKeySet()) {
                if (!this.getArgLine().contains("-D" + systemProperty + "=")) continue;
                intersection.add(systemProperty);
            }
            Set<Object> ignored = result.propertiesThatCannotBeSetASystemProperties();
            intersection.removeAll(ignored);
        }
        return intersection;
    }

    private void showToLog(SurefireProperties props, ConsoleLogger log, String setting) {
        for (Object key : props.getStringKeySet()) {
            String value = props.getProperty((String)key);
            log.debug("Setting " + setting + " [" + key + "]=[" + value + "]");
        }
    }

    private RunResult executeProvider(ProviderInfo provider, DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException, SurefireExecutionException, SurefireBooterForkException, TestSetFailedException {
        SurefireProperties effectiveProperties = this.setupProperties();
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration();
        provider.addProviderProperties();
        RunOrderParameters runOrderParameters = new RunOrderParameters(this.getRunOrder(), this.getStatisticsFile(this.getConfigChecksum()));
        if (this.isNotForking()) {
            AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveProperties, 1).copyToSystemProperties();
            InPluginVMSurefireStarter surefireStarter = this.createInprocessStarter(provider, classLoaderConfiguration, runOrderParameters);
            return surefireStarter.runSuitesInProcess(scanResult);
        }
        ForkConfiguration forkConfiguration = this.getForkConfiguration();
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showMap(this.getEnvironmentVariables(), "environment variable");
        }
        Properties originalSystemProperties = (Properties)System.getProperties().clone();
        ForkStarter forkStarter = null;
        try {
            forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration, runOrderParameters, this.getConsoleLogger());
            RunResult runResult = forkStarter.run(effectiveProperties, scanResult);
            return runResult;
        }
        catch (SurefireExecutionException e) {
            forkStarter.killOrphanForks();
            throw e;
        }
        catch (SurefireBooterForkException e) {
            forkStarter.killOrphanForks();
            throw e;
        }
        finally {
            System.setProperties(originalSystemProperties);
            this.cleanupForkConfiguration(forkConfiguration);
        }
    }

    public static SurefireProperties createCopyAndReplaceForkNumPlaceholder(SurefireProperties effectiveSystemProperties, int threadNumber) {
        SurefireProperties filteredProperties = new SurefireProperties(effectiveSystemProperties);
        String threadNumberString = String.valueOf(threadNumber);
        for (Map.Entry<Object, Object> entry : effectiveSystemProperties.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String value = (String)entry.getValue();
            value = value.replace(THREAD_NUMBER_PLACEHOLDER, threadNumberString);
            value = value.replace(FORK_NUMBER_PLACEHOLDER, threadNumberString);
            filteredProperties.put(entry.getKey(), value);
        }
        return filteredProperties;
    }

    protected void cleanupForkConfiguration(ForkConfiguration forkConfiguration) {
        if (!this.getConsoleLogger().isDebugEnabled() && forkConfiguration != null) {
            File tempDirectory = forkConfiguration.getTempDirectory();
            try {
                FileUtils.deleteDirectory(tempDirectory);
            }
            catch (IOException e) {
                this.getConsoleLogger().warning("Could not delete temp directory " + tempDirectory + " because " + e.getMessage());
            }
        }
    }

    protected void logReportsDirectory() {
        this.logDebugOrCliShowErrors(StringUtils.capitalizeFirstLetter(this.getPluginName()) + " report directory: " + this.getReportsDirectory());
    }

    final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void convertTestNGParameters() throws MojoExecutionException {
        Artifact testNgArtifact;
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        this.convertGroupParameters();
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
        if ((testNgArtifact = this.getTestNgArtifact()) != null) {
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(testNgArtifact.getVersion());
            this.getProperties().setProperty("testng.configurator", AbstractSurefireMojo.getConfiguratorName((ArtifactVersion)defaultArtifactVersion, this.getConsoleLogger()));
        }
    }

    private static String getConfiguratorName(ArtifactVersion version, PluginConsoleLogger log) throws MojoExecutionException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.2)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG4751Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2,5.3)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG52Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,5.10)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNGMapConfigurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.10,5.13)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG510Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.13,5.14.1)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG513Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.1,5.14.3)");
            if (range.containsVersion(version)) {
                log.warning("The 'reporter' or 'listener' may not work properly in TestNG 5.14.1 and 5.14.2.");
                return "org.apache.maven.surefire.testng.conf.TestNG5141Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.3,6.0)");
            if (range.containsVersion(version)) {
                if (version.equals(new DefaultArtifactVersion("[5.14.3,5.14.5]"))) {
                    throw new MojoExecutionException("TestNG 5.14.3-5.14.5 is not supported. System dependency org.testng:guice missed path.");
                }
                return "org.apache.maven.surefire.testng.conf.TestNG5143Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[6.0,)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG60Configurator";
            }
            throw new MojoExecutionException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new MojoExecutionException("Bug in plugin. Please report it with the attached stacktrace", (Exception)((Object)invsex));
        }
    }

    private void convertGroupParameters() {
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && this.getParallel().trim().length() > 0;
    }

    protected boolean isAnyGroupsSelected() {
        return this.getGroups() != null || this.getExcludedGroups() != null;
    }

    private void convertJunitCoreParameters() throws MojoExecutionException {
        String usedParallel;
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountSuites(), "suites");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountClasses(), "classes");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountMethods(), "methods");
        String string = usedParallel = this.getParallel() != null ? this.getParallel() : "none";
        if (!"none".equals(usedParallel)) {
            this.checkNonForkedThreads(this.parallel);
        }
        this.getProperties().setProperty("parallel", usedParallel);
        this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        this.getProperties().setProperty("perCoreThreadCount", Boolean.toString(this.getPerCoreThreadCount()));
        this.getProperties().setProperty("useUnlimitedThreads", Boolean.toString(this.getUseUnlimitedThreads()));
        this.getProperties().setProperty("threadcountsuites", Integer.toString(this.getThreadCountSuites()));
        this.getProperties().setProperty("threadcountclasses", Integer.toString(this.getThreadCountClasses()));
        this.getProperties().setProperty("threadcountmethods", Integer.toString(this.getThreadCountMethods()));
        this.getProperties().setProperty("paralleltimeout", Double.toString(this.getParallelTestsTimeoutInSeconds()));
        this.getProperties().setProperty("paralleltimeoutforced", Double.toString(this.getParallelTestsTimeoutForcedInSeconds()));
        this.getProperties().setProperty("paralleloptimization", Boolean.toString(this.isParallelOptimized()));
        String message = "parallel='" + usedParallel + '\'' + ", perCoreThreadCount=" + this.getPerCoreThreadCount() + ", threadCount=" + this.getThreadCount() + ", useUnlimitedThreads=" + this.getUseUnlimitedThreads() + ", threadCountSuites=" + this.getThreadCountSuites() + ", threadCountClasses=" + this.getThreadCountClasses() + ", threadCountMethods=" + this.getThreadCountMethods() + ", parallelOptimized=" + this.isParallelOptimized();
        this.logDebugOrCliShowErrors(message);
    }

    private void checkNonForkedThreads(String parallel) throws MojoExecutionException {
        if ("suites".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountSuites() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountSuites > 0 or useUnlimitedThreads=true for parallel='suites'");
            }
            this.setThreadCountClasses(0);
            this.setThreadCountMethods(0);
        } else if ("classes".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountClasses() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountClasses > 0 or useUnlimitedThreads=true for parallel='classes'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountMethods(0);
        } else if ("methods".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountMethods() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountMethods > 0 or useUnlimitedThreads=true for parallel='methods'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountClasses(0);
        } else if ("suitesAndClasses".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() == 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0) or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndClasses' or 'both'");
            }
            this.setThreadCountMethods(0);
        } else if ("suitesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndMethods'");
            }
            this.setThreadCountClasses(0);
        } else if ("both".equals(parallel) || "classesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() > this.getThreadCountClasses() && this.getThreadCountSuites() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCount > threadCountClasses) for parallel='both' or parallel='classesAndMethods'");
            }
            this.setThreadCountSuites(0);
        } else if ("all".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 && this.getThreadCount() > this.getThreadCountSuites() + this.getThreadCountClasses())) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0 and threadCountMethods > 0), or every thread-count is specified, or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0 and threadCount > threadCountSuites + threadCountClasses) for parallel='all'");
            }
        } else {
            throw new MojoExecutionException("Illegal parallel='" + parallel + "'");
        }
    }

    private boolean onlyThreadCount() {
        return this.getThreadCount() > 0 && this.getThreadCountSuites() == 0 && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0;
    }

    private static void checkThreadCountEntity(int count, String entity) throws MojoExecutionException {
        if (count < 0) {
            throw new MojoExecutionException("parallel maven execution does not allow negative thread-count" + entity);
        }
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    static boolean isForkModeNever(String forkMode) {
        return "never".equals(forkMode);
    }

    protected boolean isForking() {
        return 0 < this.getEffectiveForkCount();
    }

    String getEffectiveForkMode() {
        String forkMode1 = this.getForkMode();
        if (this.toolchain != null && AbstractSurefireMojo.isForkModeNever(forkMode1)) {
            return "once";
        }
        return ForkConfiguration.getEffectiveForkMode(forkMode1);
    }

    private List<RunOrder> getRunOrders() {
        String runOrderString = this.getRunOrder();
        RunOrder[] runOrder = runOrderString == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti((String)runOrderString);
        return Arrays.asList(runOrder);
    }

    private boolean requiresRunHistory() {
        List<RunOrder> runOrders = this.getRunOrders();
        return runOrders.contains(RunOrder.BALANCED) || runOrders.contains(RunOrder.FAILEDFIRST);
    }

    private boolean getEffectiveFailIfNoTests() {
        if (this.isSpecificTestSpecified()) {
            if (this.getFailIfNoSpecifiedTests() != null) {
                return this.getFailIfNoSpecifiedTests();
            }
            if (this.getFailIfNoTests() != null) {
                return this.getFailIfNoTests();
            }
            return true;
        }
        return this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
    }

    private ProviderConfiguration createProviderConfiguration(RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        boolean actualFailIfNoTests;
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(this.getReportsDirectory(), this.isTrimStackTrace());
        Artifact testNgArtifact = this.getTestNgArtifact();
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        TestRequest testSuiteDefinition = new TestRequest(this.suiteXmlFiles(), this.getTestSourceDirectory(), this.getSpecificTests(), this.getRerunFailingTestsCount());
        DirectoryScannerParameters directoryScannerParameters = null;
        if (this.hasSuiteXmlFiles() && !this.isSpecificTestSpecified()) {
            boolean bl = actualFailIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            if (this.isSpecificTestSpecified()) {
                actualFailIfNoTests = this.getEffectiveFailIfNoTests();
                this.setFailIfNoTests(actualFailIfNoTests);
            } else {
                actualFailIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            }
            List<String> actualIncludes = this.getIncludeList();
            List<String> actualExcludes = this.getExcludeList();
            List specificTests = Collections.emptyList();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), actualIncludes, actualExcludes, specificTests, actualFailIfNoTests, this.getRunOrder());
        }
        Map<String, String> providerProperties = AbstractSurefireMojo.toStringProperties(this.getProperties());
        return new ProviderConfiguration(directoryScannerParameters, runOrderParameters, actualFailIfNoTests, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null, false, this.cli, this.getSkipAfterFailureCount(), Shutdown.parameterOf((String)this.getShutdown()), Integer.valueOf(this.getForkedProcessExitTimeoutInSeconds()));
    }

    private static Map<String, String> toStringProperties(Properties properties) {
        ConcurrentHashMap<String, String> h = new ConcurrentHashMap<String, String>(properties.size());
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = properties.get(k);
            if (k.getClass() != String.class || v.getClass() != String.class) continue;
            h.put((String)k, (String)v);
        }
        return h;
    }

    public File getStatisticsFile(String configurationHash) {
        return new File(this.getBasedir(), ".surefire-" + configurationHash);
    }

    StartupConfiguration createStartupConfiguration(ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        try {
            String providerName = provider.getProviderName();
            Classpath providerClasspath = ClasspathCache.getCachedClassPath(providerName);
            if (providerClasspath == null) {
                providerClasspath = provider.getProviderClasspath();
                ClasspathCache.setCachedClasspath(providerName, providerClasspath);
            }
            Artifact surefireArtifact = this.getCommonArtifact();
            Classpath inprocClassPath = providerClasspath.addClassPathElementUrl(surefireArtifact.getFile().getAbsolutePath()).addClassPathElementUrl(this.getApiArtifact().getFile().getAbsolutePath());
            Classpath testClasspath = this.generateTestClasspath();
            this.getConsoleLogger().debug(testClasspath.getLogMessage("test"));
            this.getConsoleLogger().debug(providerClasspath.getLogMessage("provider"));
            this.getConsoleLogger().debug(testClasspath.getCompactLogMessage("test(compact)"));
            this.getConsoleLogger().debug(providerClasspath.getCompactLogMessage("provider(compact)"));
            ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(testClasspath, providerClasspath, inprocClassPath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
            return new StartupConfiguration(providerName, classpathConfiguration, classLoaderConfiguration, this.isForking(), false);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
    }

    private Artifact getCommonArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:maven-surefire-common");
    }

    private Artifact getApiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-api");
    }

    private StartupReportConfiguration getStartupReportConfiguration(String configChecksum) {
        return new StartupReportConfiguration(this.isUseFile(), this.isPrintSummary(), this.getReportFormat(), this.isRedirectTestOutputToFile(), this.isDisableXmlReport(), this.getReportsDirectory(), this.isTrimStackTrace(), this.getReportNameSuffix(), this.getStatisticsFile(configChecksum), this.requiresRunHistory(), this.getRerunFailingTestsCount(), this.getReportSchemaLocation());
    }

    private boolean isSpecificTestSpecified() {
        return StringUtils.isNotBlank(this.getTest());
    }

    @Nonnull
    private List<String> readListFromFile(@Nonnull File file) {
        this.getConsoleLogger().debug("Reading list from: " + file);
        if (!file.exists()) {
            throw new RuntimeException("Failed to load list from file: " + file);
        }
        try {
            List<String> list = FileUtils.loadFile(file);
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug("List contents:");
                for (String entry : list) {
                    this.getConsoleLogger().debug("  " + entry);
                }
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load list from file: " + file, e);
        }
    }

    private void maybeAppendList(List<String> base, List<String> list) {
        if (list != null) {
            base.addAll(list);
        }
    }

    @Nonnull
    private List<String> getExcludeList() throws MojoFailureException {
        List<String> actualExcludes = null;
        if (this.isSpecificTestSpecified()) {
            actualExcludes = Collections.emptyList();
        } else {
            if (this.getExcludesFile() != null) {
                actualExcludes = this.readListFromFile(this.getExcludesFile());
            }
            if (actualExcludes == null) {
                actualExcludes = this.getExcludes();
            } else {
                this.maybeAppendList(actualExcludes, this.getExcludes());
            }
            this.checkMethodFilterInIncludesExcludes(actualExcludes);
            if (actualExcludes == null || actualExcludes.isEmpty()) {
                actualExcludes = Collections.singletonList(this.getDefaultExcludes());
            }
        }
        return this.filterNulls(actualExcludes);
    }

    private List<String> getIncludeList() throws MojoFailureException {
        List<String> includes = null;
        if (this.isSpecificTestSpecified()) {
            includes = new ArrayList<String>();
            Collections.addAll(includes, StringUtils.split(this.getTest(), ","));
        } else {
            if (this.getIncludesFile() != null) {
                includes = this.readListFromFile(this.getIncludesFile());
            }
            if (includes == null) {
                includes = this.getIncludes();
            } else {
                this.maybeAppendList(includes, this.getIncludes());
            }
            this.checkMethodFilterInIncludesExcludes(includes);
            if (includes == null || includes.isEmpty()) {
                includes = Arrays.asList(this.getDefaultIncludes());
            }
        }
        return this.filterNulls(includes);
    }

    private void checkMethodFilterInIncludesExcludes(Iterable<String> patterns) throws MojoFailureException {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (pattern == null || !pattern.contains("#")) continue;
                throw new MojoFailureException("Method filter prohibited in includes|excludes|includesFile|excludesFile parameter: " + pattern);
            }
        }
    }

    private TestListResolver getIncludedAndExcludedTests() throws MojoFailureException {
        if (this.includedExcludedTests == null) {
            this.includedExcludedTests = new TestListResolver(this.getIncludeList(), this.getExcludeList());
        }
        return this.includedExcludedTests;
    }

    public TestListResolver getSpecificTests() {
        if (this.specificTests == null) {
            this.specificTests = new TestListResolver(this.getTest());
        }
        return this.specificTests;
    }

    @Nonnull
    private List<String> filterNulls(@Nonnull List<String> toFilter) {
        ArrayList<String> result = new ArrayList<String>(toFilter.size());
        for (String item : toFilter) {
            if (item == null || (item = item.trim()).length() == 0) continue;
            result.add(item);
        }
        return result;
    }

    private Artifact getTestNgArtifact() throws MojoExecutionException {
        Artifact artifact = this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact != null) {
            VersionRange range = this.createVersionRange();
            if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
                throw new MojoExecutionException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
            }
        } else if (projectArtifactName.equals(this.getTestNGArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private VersionRange createVersionRange() {
        try {
            return VersionRange.createFromVersionSpec((String)"[4.7,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private Artifact getJunitArtifact() {
        Artifact artifact = this.getProjectArtifactMap().get(this.getJunitArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact == null && projectArtifactName.equals(this.getJunitArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private Artifact getJunitDepArtifact() {
        return this.getProjectArtifactMap().get("junit:junit-dep");
    }

    private ForkStarter createForkStarter(ProviderInfo provider, ForkConfiguration forkConfiguration, ClassLoaderConfiguration classLoaderConfiguration, RunOrderParameters runOrderParameters, ConsoleLogger log) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new ForkStarter(providerConfiguration, startupConfiguration, forkConfiguration, this.getForkedProcessTimeoutInSeconds(), startupReportConfiguration, log);
    }

    private InPluginVMSurefireStarter createInprocessStarter(ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration, RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new InPluginVMSurefireStarter(startupConfiguration, providerConfiguration, startupReportConfiguration, this.consoleLogger);
    }

    protected ForkConfiguration getForkConfiguration() {
        File tmpDir = this.getSurefireTempDir();
        tmpDir.mkdirs();
        Artifact shadeFire = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shadefire");
        Classpath bootClasspathConfiguration = this.getArtifactClasspath(shadeFire != null ? shadeFire : this.surefireBooterArtifact);
        return new ForkConfiguration(bootClasspathConfiguration, tmpDir, this.getEffectiveDebugForkedProcess(), this.getEffectiveJvm(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks);
    }

    private void convertDeprecatedForkMode() {
        String effectiveForkMode = this.getEffectiveForkMode();
        if ("perthread".equals(effectiveForkMode)) {
            this.forkCount = String.valueOf(this.threadCount);
        } else if ("never".equals(effectiveForkMode)) {
            this.forkCount = "0";
        } else if ("always".equals(effectiveForkMode)) {
            this.forkCount = "1";
            this.reuseForks = false;
        }
        if (!"once".equals(this.getForkMode())) {
            this.getConsoleLogger().warning("The parameter forkMode is deprecated since version 2.14. Use forkCount and reuseForks instead.");
        }
    }

    protected int getEffectiveForkCount() {
        if (this.effectiveForkCount < 0) {
            try {
                this.effectiveForkCount = this.convertWithCoreCount(this.forkCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.effectiveForkCount < 0) {
                throw new IllegalArgumentException("Fork count " + this.forkCount.trim() + " is not a legal value.");
            }
        }
        return this.effectiveForkCount;
    }

    protected int convertWithCoreCount(String count) {
        String trimmed = count.trim();
        if (trimmed.endsWith("C")) {
            double multiplier = Double.parseDouble(trimmed.substring(0, trimmed.length() - 1));
            double calculated = multiplier * (double)Runtime.getRuntime().availableProcessors();
            return calculated > 0.0 ? Math.max((int)calculated, 1) : 0;
        }
        return Integer.parseInt(trimmed);
    }

    private String getEffectiveDebugForkedProcess() {
        String debugForkedProcess = this.getDebugForkedProcess();
        if ("true".equals(debugForkedProcess)) {
            return "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
        return debugForkedProcess;
    }

    private String getEffectiveJvm() {
        String jvmToUse = this.getJvm();
        if (this.toolchain != null && jvmToUse == null) {
            jvmToUse = this.toolchain.findTool("java");
        }
        if (StringUtils.isEmpty(jvmToUse)) {
            jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            this.getConsoleLogger().debug("Using JVM: " + jvmToUse);
        }
        return jvmToUse;
    }

    private Artifact getSurefireBooterArtifact() {
        Artifact artifact = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (artifact == null) {
            throw new RuntimeException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        artifact.isSnapshot();
        return artifact;
    }

    private File getSurefireTempDir() {
        return new File(this.getProjectBuildDirectory(), this.getTempDir());
    }

    private String getConfigChecksum() {
        ChecksumCalculator checksum = new ChecksumCalculator();
        checksum.add(this.getPluginName());
        checksum.add(this.isSkipTests());
        checksum.add(this.isSkipExec());
        checksum.add(this.isSkip());
        checksum.add(this.getTestClassesDirectory());
        checksum.add(this.getClassesDirectory());
        checksum.add(this.getClasspathDependencyExcludes());
        checksum.add(this.getClasspathDependencyScopeExclude());
        checksum.add(this.getAdditionalClasspathElements());
        checksum.add(this.getReportsDirectory());
        checksum.add(this.getProjectBuildDirectory());
        checksum.add(this.getTestSourceDirectory());
        checksum.add(this.getTest());
        checksum.add(this.getIncludes());
        checksum.add(this.getSkipAfterFailureCount());
        checksum.add(this.getShutdown());
        checksum.add(this.getExcludes());
        checksum.add(this.getLocalRepository());
        checksum.add(this.getSystemProperties());
        checksum.add(this.getSystemPropertyVariables());
        checksum.add(this.getSystemPropertiesFile());
        checksum.add(this.getProperties());
        checksum.add(this.isPrintSummary());
        checksum.add(this.getReportFormat());
        checksum.add(this.getReportNameSuffix());
        checksum.add(this.isUseFile());
        checksum.add(this.isRedirectTestOutputToFile());
        checksum.add(this.getForkMode());
        checksum.add(this.getForkCount());
        checksum.add(this.isReuseForks());
        checksum.add(this.getJvm());
        checksum.add(this.getArgLine());
        checksum.add(this.getDebugForkedProcess());
        checksum.add(this.getForkedProcessTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutForcedInSeconds());
        checksum.add(this.getEnvironmentVariables());
        checksum.add(this.getWorkingDirectory());
        checksum.add(this.isChildDelegation());
        checksum.add(this.getGroups());
        checksum.add(this.getExcludedGroups());
        checksum.add(this.getSuiteXmlFiles());
        checksum.add(this.getJunitArtifact());
        checksum.add(this.getTestNGArtifactName());
        checksum.add(this.getThreadCount());
        checksum.add(this.getThreadCountSuites());
        checksum.add(this.getThreadCountClasses());
        checksum.add(this.getThreadCountMethods());
        checksum.add(this.getPerCoreThreadCount());
        checksum.add(this.getUseUnlimitedThreads());
        checksum.add(this.getParallel());
        checksum.add(this.isParallelOptimized());
        checksum.add(this.isTrimStackTrace());
        checksum.add(this.getRemoteRepositories());
        checksum.add(this.isDisableXmlReport());
        checksum.add(this.isUseSystemClassLoader());
        checksum.add(this.isUseManifestOnlyJar());
        checksum.add(this.isEnableAssertions());
        checksum.add(this.getObjectFactory());
        checksum.add(this.getFailIfNoTests());
        checksum.add(this.getRunOrder());
        checksum.add(this.getDependenciesToScan());
        checksum.add(this.getForkedProcessExitTimeoutInSeconds());
        checksum.add(this.getRerunFailingTestsCount());
        checksum.add(this.getTempDir());
        this.addPluginSpecificChecksumItems(checksum);
        return checksum.getSha1();
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
    }

    protected boolean hasExecutedBefore() {
        String configChecksum = this.getConfigChecksum();
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(configChecksum)) {
            this.getConsoleLogger().info("Skipping execution of surefire because it has already been run for this configuration");
            return true;
        }
        pluginContext.put(configChecksum, configChecksum);
        return false;
    }

    protected ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.isForking() ? new ClassLoaderConfiguration(this.isUseSystemClassLoader(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    private Classpath generateTestClasspath() throws InvalidVersionSpecificationException, MojoFailureException, ArtifactResolutionException, ArtifactNotFoundException, MojoExecutionException {
        Object dependencyFilter;
        ArrayList<String> classpath = new ArrayList<String>(2 + this.getProject().getArtifacts().size());
        classpath.add(this.getTestClassesDirectory().getAbsolutePath());
        classpath.add(this.getClassesDirectory().getAbsolutePath());
        Set<Artifact> classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().isEmpty()) {
            dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            dependencyFilter = new PatternIncludesArtifactFilter(Arrays.asList(this.getClasspathDependencyExcludes()));
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        for (Artifact artifact : classpathArtifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getPath());
        }
        if (this.getAdditionalClasspathElements() != null) {
            for (String classpathElement : this.getAdditionalClasspathElements()) {
                if (classpathElement == null) continue;
                Collections.addAll(classpath, StringUtils.split(classpathElement, ","));
            }
        }
        if (this.getTestNgArtifact() != null) {
            this.addTestNgUtilsArtifacts(classpath);
        }
        return new Classpath(classpath);
    }

    private void addTestNgUtilsArtifacts(List<String> classpath) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact[] extraTestNgArtifacts;
        Artifact surefireArtifact = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        String surefireVersion = surefireArtifact.getBaseVersion();
        for (Artifact artifact : extraTestNgArtifacts = new Artifact[]{this.getArtifactFactory().createArtifact("org.apache.maven.surefire", "surefire-testng-utils", surefireVersion, "runtime", "jar"), this.getArtifactFactory().createArtifact("org.apache.maven.surefire", "surefire-grouper", surefireVersion, "runtime", "jar")}) {
            this.getArtifactResolver().resolve(artifact, this.getRemoteRepositories(), this.getLocalRepository());
            String path = artifact.getFile().getPath();
            classpath.add(path);
        }
    }

    private Set<Artifact> filterArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map<?, ?> map, String setting) {
        for (Object o : map.keySet()) {
            String key = (String)o;
            String value = (String)map.get(key);
            this.getConsoleLogger().debug("Setting " + setting + " [" + key + "]=[" + value + "]");
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.getArtifactFactory().createBuildArtifact("dummy", "dummy", "1.0", "jar");
        try {
            return this.getArtifactResolver().resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), (ArtifactFilter)filter);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Classpath getArtifactClasspath(Artifact surefireArtifact) {
        Classpath existing = ClasspathCache.getCachedClassPath(surefireArtifact.getArtifactId());
        if (existing == null) {
            ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
            ArrayList<String> items = new ArrayList<String>();
            for (Object o : result.getArtifacts()) {
                Artifact artifact = (Artifact)o;
                this.getConsoleLogger().debug("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope());
                items.add(artifact.getFile().getAbsolutePath());
            }
            existing = new Classpath(items);
            ClasspathCache.setCachedClasspath(surefireArtifact.getArtifactId(), existing);
        }
        return existing;
    }

    private Properties getUserProperties() {
        Properties props = null;
        try {
            Method getUserProperties = this.getSession().getClass().getMethod("getUserProperties", new Class[0]);
            props = (Properties)getUserProperties.invoke((Object)this.getSession(), new Object[0]);
        }
        catch (Exception e) {
            String msg = "Build uses Maven 2.0.x, cannot propagate system properties from command line to tests (cf. SUREFIRE-121)";
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug(msg, e);
            }
            this.getConsoleLogger().warning(msg);
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    private void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (this.getWorkingDirectory() == null) {
            throw new MojoFailureException("workingDirectory cannot be null");
        }
        if (this.isForking()) {
            return;
        }
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    private void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isNotForking()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkCount 0");
        }
    }

    private void ensureThreadCountWithPerThread() throws MojoFailureException {
        if ("perthread".equals(this.getEffectiveForkMode()) && this.getThreadCount() < 1) {
            throw new MojoFailureException("Fork mode perthread requires a thread count");
        }
    }

    private void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.isUseSystemClassLoader() && this.isNotForking()) {
            this.getConsoleLogger().warning("useSystemClassloader setting has no effect when not forking");
        }
    }

    private boolean isNotForking() {
        return !this.isForking();
    }

    private List<CommandLineOption> commandLineOptions() {
        return SurefireHelper.commandLineOptions(this.getSession(), this.getConsoleLogger());
    }

    private void warnIfDefunctGroupsCombinations() throws MojoFailureException, MojoExecutionException {
        Artifact junitArtifact;
        boolean junit47Compatible;
        if (this.isAnyGroupsSelected() && this.getTestNgArtifact() == null && !(junit47Compatible = this.isJunit47Compatible(junitArtifact = this.getJunitArtifact()))) {
            if (junitArtifact != null) {
                throw new MojoFailureException("groups/excludedGroups are specified but JUnit version on classpath is too old to support groups. Check your dependency:tree to see if your project is picking up an old junit version");
            }
            throw new MojoFailureException("groups/excludedGroups require TestNG or JUnit48+ on project test classpath");
        }
    }

    private void warnIfRerunClashes() throws MojoFailureException {
        if (this.getRerunFailingTestsCount() < 0) {
            throw new MojoFailureException("Parameter \"rerunFailingTestsCount\" should not be negative.");
        }
        if (this.getSkipAfterFailureCount() < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
    }

    private void warnIfWrongShutdownValue() throws MojoFailureException {
        if (!Shutdown.isKnown((String)this.getShutdown())) {
            throw new MojoFailureException("Parameter \"shutdown\" should have values " + Shutdown.listParameters());
        }
    }

    private void warnIfNotApplicableSkipAfterFailureCount() throws MojoFailureException {
        int skipAfterFailureCount = this.getSkipAfterFailureCount();
        if (skipAfterFailureCount < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
        if (skipAfterFailureCount > 0) {
            try {
                Artifact testng = this.getTestNgArtifact();
                if (testng != null) {
                    VersionRange range = VersionRange.createFromVersionSpec((String)"[5.10,)");
                    if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testng.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects TestNG Version 5.10 or higher. java.lang.NoClassDefFoundError: org/testng/IInvokedMethodListener");
                    }
                } else {
                    VersionRange range;
                    Artifact junit = this.getJunitArtifact();
                    if (junit != null && !(range = VersionRange.createFromVersionSpec((String)"[4.0,)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(junit.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects JUnit Version 4.0 or higher. java.lang.NoSuchMethodError: org.junit.runner.notification.RunNotifier.pleaseStop()V");
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException(e.getLocalizedMessage());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void warnIfIllegalTempDir() throws MojoFailureException {
        if (StringUtils.isEmpty(this.getTempDir())) {
            throw new MojoFailureException("Parameter 'tempDir' should not be blank string.");
        }
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    private Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map<String, Artifact> pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map<String, Artifact> getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map<String, Artifact> projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public void setReportNameSuffix(String reportNameSuffix) {
        this.reportNameSuffix = reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(boolean perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public boolean getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(boolean useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isParallelOptimized() {
        return this.parallelOptimized;
    }

    public void setParallelOptimized(boolean parallelOptimized) {
        this.parallelOptimized = parallelOptimized;
    }

    public int getThreadCountSuites() {
        return this.threadCountSuites;
    }

    public void setThreadCountSuites(int threadCountSuites) {
        this.threadCountSuites = threadCountSuites;
    }

    public int getThreadCountClasses() {
        return this.threadCountClasses;
    }

    public void setThreadCountClasses(int threadCountClasses) {
        this.threadCountClasses = threadCountClasses;
    }

    public int getThreadCountMethods() {
        return this.threadCountMethods;
    }

    public void setThreadCountMethods(int threadCountMethods) {
        this.threadCountMethods = threadCountMethods;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public boolean effectiveIsEnableAssertions() {
        List<String> args;
        if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
            return false;
        }
        return this.isEnableAssertions();
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public String[] getDependenciesToScan() {
        return this.dependenciesToScan;
    }

    public void setDependenciesToScan(String[] dependenciesToScan) {
        this.dependenciesToScan = dependenciesToScan;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    @Override
    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getForkCount() {
        return this.forkCount;
    }

    public boolean isReuseForks() {
        return this.reuseForks;
    }

    public String[] getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(String[] additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public String[] getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(String[] classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public File getProjectBuildDirectory() {
        return this.projectBuildDirectory;
    }

    public void setProjectBuildDirectory(File projectBuildDirectory) {
        this.projectBuildDirectory = projectBuildDirectory;
    }

    protected void logDebugOrCliShowErrors(String s) {
        SurefireHelper.logDebugOrCliShowErrors(s, this.getConsoleLogger(), this.cli);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    final class ProviderList {
        private final ProviderInfo[] wellKnownProviders;
        private final ConfigurableProviderInfo dynamicProvider;

        ProviderList(ConfigurableProviderInfo dynamicProviderInfo, ProviderInfo ... wellKnownProviders) {
            this.wellKnownProviders = wellKnownProviders;
            this.dynamicProvider = dynamicProviderInfo;
        }

        @Nonnull
        List<ProviderInfo> resolve() {
            ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
            Set<String> manuallyConfiguredProviders = this.getManuallyConfiguredProviders();
            for (String name : manuallyConfiguredProviders) {
                ProviderInfo wellKnown = this.findByName(name);
                ProviderInfo providerToAdd = wellKnown != null ? wellKnown : this.dynamicProvider.instantiate(name);
                AbstractSurefireMojo.this.logDebugOrCliShowErrors("Using configured provider " + providerToAdd.getProviderName());
                providersToRun.add(providerToAdd);
            }
            return manuallyConfiguredProviders.isEmpty() ? this.autoDetectOneProvider() : providersToRun;
        }

        @Nonnull
        private List<ProviderInfo> autoDetectOneProvider() {
            ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
            for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
                if (!wellKnownProvider.isApplicable()) continue;
                providersToRun.add(wellKnownProvider);
                return providersToRun;
            }
            return providersToRun;
        }

        private Set<String> getManuallyConfiguredProviders() {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return AbstractSurefireMojo.this.providerDetector.lookupServiceNames(SurefireProvider.class, cl);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ProviderInfo findByName(String providerClassName) {
            for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
                if (!wellKnownProvider.getProviderName().equals(providerClassName)) continue;
                return wellKnownProvider;
            }
            return null;
        }
    }

    final class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Map<String, Artifact> pluginArtifactMap = AbstractSurefireMojo.this.getPluginArtifactMap();
            Artifact plugin = pluginArtifactMap.get("org.apache.maven.plugins:maven-surefire-plugin");
            return AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(pluginArtifactMap, plugin);
        }
    }

    final class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        private boolean is47CompatibleJunitDep() {
            return this.junitDepArtifact != null && AbstractSurefireMojo.this.isJunit47Compatible(this.junitDepArtifact);
        }

        @Override
        public boolean isApplicable() {
            boolean isJunitArtifact47 = AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
            boolean isAny47ProvidersForcers = AbstractSurefireMojo.this.isAnyConcurrencySelected() || AbstractSurefireMojo.this.isAnyGroupsSelected();
            return isAny47ProvidersForcers && (isJunitArtifact47 || this.is47CompatibleJunitDep());
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertGroupParameters();
        }

        @Override
        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit47", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    final class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        @Override
        public boolean isApplicable() {
            return this.junitDepArtifact != null || AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
        }

        @Override
        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit4", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    final class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
        }

        @Override
        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit3", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    final class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        @Override
        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Artifact surefireArtifact = AbstractSurefireMojo.this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-testng", surefireArtifact.getBaseVersion(), this.testNgArtifact);
        }
    }
}

