/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.lazytestprovider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.FlushReceiverProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProvidingInputStream
extends InputStream {
    private final Queue<String> testItemQueue;
    private byte[] currentBuffer;
    private int currentPos;
    private Semaphore semaphore = new Semaphore(0);
    private FlushReceiverProvider flushReceiverProvider;

    public TestProvidingInputStream(Queue<String> testItemQueue) {
        this.testItemQueue = testItemQueue;
    }

    public void setFlushReceiverProvider(FlushReceiverProvider flushReceiverProvider) {
        this.flushReceiverProvider = flushReceiverProvider;
    }

    @Override
    public synchronized int read() throws IOException {
        if (null == this.currentBuffer) {
            if (null != this.flushReceiverProvider && null != this.flushReceiverProvider.getFlushReceiver()) {
                this.flushReceiverProvider.getFlushReceiver().flush();
            }
            this.semaphore.acquireUninterruptibly();
            String currentElement = this.testItemQueue.poll();
            if (null != currentElement) {
                this.currentBuffer = currentElement.getBytes();
                this.currentPos = 0;
            } else {
                return -1;
            }
        }
        if (this.currentPos < this.currentBuffer.length) {
            return this.currentBuffer[this.currentPos++] & 0xFF;
        }
        this.currentBuffer = null;
        return 10;
    }

    public void provideNewTest() {
        this.semaphore.release();
    }
}

