/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.WriterStreamConsumer;
import org.apache.maven.shared.utils.io.FileUtils;

class ForkedLauncher
implements MavenLauncher {
    private final String mavenHome;
    private final String executable;
    private final Map<String, String> envVars;

    ForkedLauncher(String mavenHome) {
        this(mavenHome, Collections.emptyMap(), false);
    }

    ForkedLauncher(String mavenHome, Map<String, String> envVars, boolean debugJvm) {
        this(mavenHome, envVars, debugJvm, false);
    }

    ForkedLauncher(String mavenHome, Map<String, String> envVars, boolean debugJvm, boolean wrapper) {
        this.mavenHome = mavenHome;
        this.envVars = envVars;
        if (wrapper) {
            StringBuilder script = new StringBuilder();
            if (!ForkedLauncher.isWindows()) {
                script.append("./");
            }
            script.append("mvnw");
            if (debugJvm) {
                script.append("Debug");
            }
            this.executable = script.toString();
        } else {
            String script = "mvn" + (debugJvm ? "Debug" : "");
            this.executable = mavenHome != null ? new File(mavenHome, "bin/" + script).getPath() : script;
        }
    }

    public int run(String[] cliArgs, Properties systemProperties, Map<String, String> envVars, String workingDirectory, File logFile) throws IOException, LauncherException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.executable);
        if (this.mavenHome != null) {
            cmd.addEnvironment("M2_HOME", this.mavenHome);
        }
        if (envVars != null) {
            for (Map.Entry<String, String> envVar : envVars.entrySet()) {
                cmd.addEnvironment(envVar.getKey(), envVar.getValue());
            }
        }
        if (envVars == null || envVars.get("JAVA_HOME") == null) {
            cmd.addEnvironment("JAVA_HOME", System.getProperty("java.home"));
        }
        cmd.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cmd.setWorkingDirectory(workingDirectory);
        for (Object o : systemProperties.keySet()) {
            String key = (String)o;
            String string = systemProperties.getProperty(key);
            cmd.createArg().setValue("-D" + key + "=" + string);
        }
        for (Iterator<Object> iterator : cliArgs) {
            cmd.createArg().setValue(iterator);
        }
        FileWriter logWriter = new FileWriter(logFile);
        WriterStreamConsumer out = new WriterStreamConsumer((Writer)logWriter);
        WriterStreamConsumer err = new WriterStreamConsumer((Writer)logWriter);
        try {
            int n = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            return n;
        }
        catch (CommandLineException commandLineException) {
            throw new LauncherException("Failed to run Maven: " + commandLineException.getMessage() + "\n" + cmd, commandLineException);
        }
        finally {
            ((Writer)logWriter).close();
        }
    }

    @Override
    public int run(String[] cliArgs, Properties systemProperties, String workingDirectory, File logFile) throws IOException, LauncherException {
        return this.run(cliArgs, systemProperties, this.envVars, workingDirectory, logFile);
    }

    @Override
    public String getMavenVersion() throws IOException, LauncherException {
        File logFile;
        try {
            logFile = File.createTempFile("maven", "log");
        }
        catch (IOException e) {
            throw new LauncherException("Error creating temp file", e);
        }
        Map<String, String> envVars = Collections.singletonMap("MAVEN_OPTS", "-Demma.rt.control=false");
        this.run(new String[]{"--version"}, new Properties(), envVars, null, logFile);
        List logLines = FileUtils.loadFile((File)logFile);
        logFile.delete();
        String version = ForkedLauncher.extractMavenVersion(logLines);
        if (version == null) {
            throw new LauncherException("Illegal Maven output: String 'Maven' not found in the following output:\n" + StringUtils.join(logLines.iterator(), (String)"\n"));
        }
        return version;
    }

    static String extractMavenVersion(List<String> logLines) {
        String version = null;
        Pattern mavenVersion = Pattern.compile("(?i).*Maven.*? ([0-9]\\.\\S*).*");
        Iterator<String> it = logLines.iterator();
        while (version == null && it.hasNext()) {
            String line = it.next();
            Matcher m = mavenVersion.matcher(line);
            if (!m.matches()) continue;
            version = m.group(1);
        }
        return version;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }
}

