package org.apache.maven.shared.utils.cli;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.IOException;

/**
 * @author <a href="mailto:evenisse@apache.org">Emmanuel Venisse</a>
 * @version $Id: DefaultConsumer.java 1784357 2017-02-25 08:11:19Z schulte $
 */
public class DefaultConsumer
    implements StreamConsumer
{

    /**
     * {@inheritDoc}
     */
    @Override
    public void consumeLine( String line ) throws IOException
    {
        System.out.println( line );
        if ( System.out.checkError() )
        {
            throw new IOException( String.format( "Failure writing line '%s' to stdout.", line ) );
        }
    }

}
