/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.io;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Java7Support {
    private static final boolean isJava7;
    private static Method isSymbolicLink;
    private static Method toPath;

    public static boolean isSymLink(File file) {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            return (Boolean)isSymbolicLink.invoke(null, path);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isJava7() {
        return isJava7;
    }

    static {
        boolean isJava7x = true;
        try {
            Class<?> files = Thread.currentThread().getContextClassLoader().loadClass("java.nio.file.Files");
            Class<?> path = Thread.currentThread().getContextClassLoader().loadClass("java.nio.file.Path");
            isSymbolicLink = files.getMethod("isSymbolicLink", path);
            toPath = File.class.getMethod("toPath", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            isJava7x = false;
        }
        catch (NoSuchMethodException e) {
            isJava7x = false;
        }
        isJava7 = isJava7x;
    }
}

