/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

public class JarSignerUtil {
    private JarSignerUtil() {
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(file));){
            result = zis.getNextEntry() != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void unsignArchive(File jarFile) throws IOException {
        File unsignedFile = new File(jarFile.getAbsolutePath() + ".unsigned");
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(unsignedFile)));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!JarSignerUtil.isSignatureFile(ze.getName())) {
                    zos.putNextEntry(new ZipEntry(ze.getName()));
                    if (JarSignerUtil.isManifestFile(ze.getName())) {
                        Manifest oldManifest = new Manifest(zis);
                        Manifest newManifest = JarSignerUtil.buildUnsignedManifest(oldManifest);
                        newManifest.write(zos);
                    } else {
                        IOUtil.copy((InputStream)zis, (OutputStream)zos);
                    }
                }
                ze = zis.getNextEntry();
            }
        }
        FileUtils.rename((File)unsignedFile, (File)jarFile);
    }

    protected static Manifest buildUnsignedManifest(Manifest manifest) {
        Manifest result = new Manifest(manifest);
        result.getEntries().clear();
        for (Map.Entry<String, Attributes> manifestEntry : manifest.getEntries().entrySet()) {
            Attributes oldAttributes = manifestEntry.getValue();
            Attributes newAttributes = new Attributes();
            for (Map.Entry<Object, Object> attributesEntry : oldAttributes.entrySet()) {
                String attributeKey = String.valueOf(attributesEntry.getKey());
                if (attributeKey.endsWith("-Digest")) continue;
                newAttributes.put(attributesEntry.getKey(), attributesEntry.getValue());
            }
            if (newAttributes.isEmpty()) continue;
            result.getEntries().put(manifestEntry.getKey(), newAttributes);
        }
        return result;
    }

    public static boolean isArchiveSigned(File jarFile) throws IOException {
        if (jarFile == null) {
            throw new NullPointerException("jarFile");
        }
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));){
            boolean signed = false;
            ZipEntry ze = in.getNextEntry();
            while (ze != null) {
                if (JarSignerUtil.isSignatureFile(ze.getName())) {
                    signed = true;
                    break;
                }
                ze = in.getNextEntry();
            }
            boolean bl = signed;
            return bl;
        }
    }

    protected static boolean isSignatureFile(String entryName) {
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            return JarSignerUtil.endsWithIgnoreCase(entryName, ".SF") || JarSignerUtil.endsWithIgnoreCase(entryName, ".DSA") || JarSignerUtil.endsWithIgnoreCase(entryName, ".RSA") || JarSignerUtil.endsWithIgnoreCase(entryName, ".EC");
        }
        return false;
    }

    protected static boolean isManifestFile(String entryName) {
        if (entryName.regionMatches(true, 0, "META-INF", 0, 8) && (entryName = entryName.replace('\\', '/')).indexOf(47) == 8 && entryName.lastIndexOf(47) == 8) {
            return JarSignerUtil.endsWithIgnoreCase(entryName, "/MANIFEST.MF");
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String searchStr) {
        return str.regionMatches(true, str.length() - searchStr.length(), searchStr, 0, searchStr.length());
    }
}

