/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Exclusion;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.ConflictData;
import org.apache.maven.shared.dependency.graph.internal.DefaultDependencyNode;

class VerboseDependencyNode
extends DefaultDependencyNode {
    private final ConflictData data;

    VerboseDependencyNode(DependencyNode parent, Artifact artifact, String premanagedVersion, String premanagedScope, String versionConstraint, Boolean optional, List<Exclusion> exclusions, ConflictData data) {
        super(parent, artifact, premanagedVersion, premanagedScope, versionConstraint, optional, exclusions);
        this.data = data;
    }

    @Override
    public String toNodeString() {
        boolean included;
        StringBuilder buffer = new StringBuilder();
        boolean bl = included = this.data.getWinnerVersion() == null;
        if (!included) {
            buffer.append('(');
        }
        buffer.append(this.getArtifact());
        ItemAppender appender = new ItemAppender(buffer, included ? " (" : " - ", "; ", included ? ")" : "");
        if (this.getPremanagedVersion() != null) {
            appender.append("version managed from ", this.getPremanagedVersion());
        }
        if (this.getPremanagedScope() != null) {
            appender.append("scope managed from ", this.getPremanagedScope());
        }
        if (this.data.getOriginalScope() != null) {
            appender.append("scope updated from ", this.data.getOriginalScope());
        }
        if (this.data.getIgnoredScope() != null) {
            appender.append("scope not updated to ", this.data.getIgnoredScope());
        }
        if (!included) {
            String winnerVersion = this.data.getWinnerVersion();
            if (winnerVersion.equals(this.getArtifact().getVersion())) {
                appender.append("omitted for duplicate");
            } else {
                appender.append("omitted for conflict with ", winnerVersion);
            }
        }
        appender.flush();
        if (!included) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static class ItemAppender {
        private StringBuilder buffer;
        private String startToken;
        private String separatorToken;
        private String endToken;
        private boolean appended;

        ItemAppender(StringBuilder buffer, String startToken, String separatorToken, String endToken) {
            this.buffer = buffer;
            this.startToken = startToken;
            this.separatorToken = separatorToken;
            this.endToken = endToken;
            this.appended = false;
        }

        public ItemAppender append(String item1) {
            this.appendToken();
            this.buffer.append(item1);
            return this;
        }

        public ItemAppender append(String item1, String item2) {
            this.appendToken();
            this.buffer.append(item1).append(item2);
            return this;
        }

        public void flush() {
            if (this.appended) {
                this.buffer.append(this.endToken);
                this.appended = false;
            }
        }

        private void appendToken() {
            this.buffer.append(this.appended ? this.separatorToken : this.startToken);
            this.appended = true;
        }
    }
}

