/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.edit;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyEditCommand
extends AbstractEditCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ScmResult executeEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing edit command...");
        }
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("basedir: " + fileSet.getBasedir());
        }
        String ccmAddr = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            String projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
            File waPath = SynergyUtil.getWorkArea(this.getLogger(), projectSpec, ccmAddr);
            File sourcePath = new File(waPath, repo.getProjectName());
            if (projectSpec == null) {
                throw new ScmException("You should checkout project first");
            }
            int taskNum = SynergyUtil.createTask(this.getLogger(), "Maven SCM Synergy provider: edit command for project " + repo.getProjectSpec(), repo.getProjectRelease(), true, ccmAddr);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Task " + taskNum + " was created to perform checkout.");
            }
            Iterator i = fileSet.getFileList().iterator();
            while (i.hasNext()) {
                File f;
                File dest = f = (File)i.next();
                File source = new File(sourcePath, SynergyUtil.removePrefix(fileSet.getBasedir(), f));
                LinkedList<File> list = new LinkedList<File>();
                list.add(source);
                SynergyUtil.checkoutFiles(this.getLogger(), list, ccmAddr);
                if (source.equals(dest)) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Copy file [" + source + "] to expected folder [" + dest + "].");
                }
                try {
                    FileUtils.copyFile((File)source, (File)dest);
                }
                catch (IOException e) {
                    throw new ScmException("Unable to copy file from Work Area", (Throwable)e);
                    return new EditScmResult("", fileSet.getFileList());
                }
            }
        }
        finally {
            SynergyUtil.stop(this.getLogger(), ccmAddr);
        }
    }
}

