/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.Os;

public class SvnConfigFileReader {
    private File configDirectory;

    public File getConfigDirectory() {
        if (this.configDirectory == null) {
            this.configDirectory = Os.isFamily((String)"windows") ? new File(System.getenv("APPDATA"), "Subversion") : new File(System.getProperty("user.home"), ".subversion");
        }
        return this.configDirectory;
    }

    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getProperty(String group, String propertyName) {
        List<String> lines = this.getConfigLines();
        boolean inGroup = false;
        Iterator<String> i = lines.iterator();
        while (i.hasNext()) {
            String property;
            String line = i.next().trim();
            if (!inGroup) {
                if (!("[" + group + "]").equals(line)) continue;
                inGroup = true;
                continue;
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                return null;
            }
            if (line.startsWith("#") || line.indexOf(61) < 0 || !(property = line.substring(0, line.indexOf(61)).trim()).equals(propertyName)) continue;
            String value = line.substring(line.indexOf(61) + 1);
            return value.trim();
        }
        return null;
    }

    private List<String> getConfigLines() {
        Path configPath = this.getConfigDirectory().toPath().resolve("config");
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                return Files.lines(configPath, StandardCharsets.UTF_8).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).collect(Collectors.toCollection(ArrayList::new));
            }
            catch (IOException | UncheckedIOException e) {
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }
}

