/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn;

import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class SvnTagBranchUtils {
    public static final String[] REVISION_SPECIFIERS = new String[]{"HEAD", "BASE", "COMMITTED", "PREV"};
    public static final String SVN_TRUNK = "trunk";
    public static final String SVN_BRANCHES = "branches";
    public static final String SVN_TAGS = "tags";
    public static final String[] SVN_BASE_DIRS = new String[]{"trunk", "branches", "tags"};

    static String appendPath(String basePath, String addlPath) {
        basePath = StringUtils.stripEnd((String)basePath, (String)"/");
        if (StringUtils.isEmpty((String)addlPath)) {
            return basePath;
        }
        return basePath + "/" + StringUtils.stripStart((String)addlPath, (String)"/");
    }

    public static String getProjectRoot(String repoPath) {
        for (int i = 0; i < SVN_BASE_DIRS.length; ++i) {
            String base = "/" + SVN_BASE_DIRS[i];
            int pos = repoPath.lastIndexOf(base + "/");
            if (repoPath.endsWith(base)) {
                return repoPath.substring(0, repoPath.length() - base.length());
            }
            if (pos < 0) continue;
            return repoPath.substring(0, pos);
        }
        return SvnTagBranchUtils.appendPath(repoPath, null);
    }

    public static String resolveTagBase(SvnScmProviderRepository repository) {
        return SvnTagBranchUtils.resolveTagBase(repository.getUrl());
    }

    public static String resolveTagBase(String repositoryUrl) {
        return SvnTagBranchUtils.appendPath(SvnTagBranchUtils.getProjectRoot(repositoryUrl), SVN_TAGS);
    }

    public static String resolveBranchBase(SvnScmProviderRepository repository) {
        return SvnTagBranchUtils.resolveBranchBase(repository.getUrl());
    }

    public static String resolveBranchBase(String repositoryUrl) {
        return SvnTagBranchUtils.appendPath(SvnTagBranchUtils.getProjectRoot(repositoryUrl), SVN_BRANCHES);
    }

    public static String resolveTagUrl(SvnScmProviderRepository repository, String tag) {
        return SvnTagBranchUtils.resolveUrl(repository.getUrl(), repository.getTagBase(), SVN_TAGS, tag);
    }

    public static String resolveTagUrl(String repositoryUrl, String tag) {
        return SvnTagBranchUtils.resolveUrl(repositoryUrl, null, SVN_TAGS, tag);
    }

    public static String resolveBranchUrl(SvnScmProviderRepository repository, String branch) {
        return SvnTagBranchUtils.resolveUrl(repository.getUrl(), repository.getBranchBase(), SVN_BRANCHES, branch);
    }

    public static String resolveBranchUrl(String repositoryUrl, String branch) {
        return SvnTagBranchUtils.resolveUrl(repositoryUrl, SvnTagBranchUtils.resolveBranchBase(repositoryUrl), SVN_BRANCHES, branch);
    }

    private static String addSuffix(String baseString, String suffix) {
        return suffix != null ? baseString + suffix : baseString;
    }

    public static String resolveUrl(String repositoryUrl, String tagBase, String subdir, String branchTagName) {
        String projectRoot = SvnTagBranchUtils.getProjectRoot(repositoryUrl);
        if (StringUtils.isEmpty((String)(branchTagName = StringUtils.strip((String)branchTagName, (String)"/")))) {
            return null;
        }
        String queryString = null;
        if (repositoryUrl.indexOf("?") >= 0) {
            queryString = repositoryUrl.substring(repositoryUrl.indexOf("?"));
        }
        if (branchTagName.indexOf("://") >= 0) {
            return branchTagName;
        }
        if (StringUtils.isNotEmpty((String)tagBase) && !tagBase.equals(SvnTagBranchUtils.resolveTagBase(repositoryUrl)) && !tagBase.equals(SvnTagBranchUtils.resolveBranchBase(repositoryUrl))) {
            return SvnTagBranchUtils.appendPath(tagBase, branchTagName);
        }
        for (int i = 0; i < SVN_BASE_DIRS.length; ++i) {
            if (!branchTagName.startsWith(SVN_BASE_DIRS[i] + "/")) continue;
            return SvnTagBranchUtils.addSuffix(SvnTagBranchUtils.appendPath(projectRoot, branchTagName), queryString);
        }
        return SvnTagBranchUtils.addSuffix(SvnTagBranchUtils.appendPath(SvnTagBranchUtils.appendPath(projectRoot, subdir), branchTagName), queryString);
    }

    private static boolean checkRevisionArg(String arg) {
        if (StringUtils.isNumeric((String)arg) || arg.startsWith("{") && arg.endsWith("}")) {
            return true;
        }
        for (int i = 0; i < REVISION_SPECIFIERS.length; ++i) {
            if (!REVISION_SPECIFIERS[i].equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRevisionSpecifier(String tag) {
        if (StringUtils.isEmpty((String)tag)) {
            return false;
        }
        if (SvnTagBranchUtils.checkRevisionArg(tag)) {
            return true;
        }
        String[] parts = StringUtils.split((String)tag, (String)":");
        if (parts.length == 2 && StringUtils.isNotEmpty((String)parts[0]) && StringUtils.isNotEmpty((String)parts[1])) {
            return SvnTagBranchUtils.checkRevisionArg(parts[0]) && SvnTagBranchUtils.checkRevisionArg(parts[1]);
        }
        return false;
    }
}

