/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.checkout;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.LocalCommand;
import org.apache.maven.scm.provider.local.command.checkout.LocalCheckOutScmResult;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadataUtils;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;

public class LocalCheckOutCommand
extends AbstractCheckOutCommand
implements LocalCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        List<ScmFile> checkedOutFiles;
        LocalScmProviderRepository repository = (LocalScmProviderRepository)repo;
        if (version != null) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        File root = new File(repository.getRoot());
        String module = repository.getModule();
        File source = new File(root, module);
        File baseDestination = fileSet.getBasedir();
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        try {
            if (baseDestination.exists()) {
                FileUtils.deleteDirectory((File)baseDestination);
            }
            if (!baseDestination.mkdirs()) {
                throw new ScmException("Could not create destination directory '" + baseDestination.getAbsolutePath() + "'.");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Checking out '" + source.getAbsolutePath() + "' to '" + baseDestination.getAbsolutePath() + "'.");
            }
            List fileList = fileSet.getFileList().isEmpty() ? FileUtils.getFiles((File)source.getAbsoluteFile(), (String)"**", null) : fileSet.getFileList();
            checkedOutFiles = this.checkOut(source, baseDestination, fileList, repository.getModule());
            LocalScmMetadataUtils metadataUtils = new LocalScmMetadataUtils();
            metadataUtils.writeMetadata(baseDestination, metadataUtils.buildMetadata(source));
        }
        catch (IOException ex) {
            throw new ScmException("Error while checking out the files.", (Throwable)ex);
        }
        return new LocalCheckOutScmResult(null, checkedOutFiles);
    }

    private List<ScmFile> checkOut(File source, File baseDestination, List<File> files, String module) throws ScmException, IOException {
        String sourcePath = source.getAbsolutePath();
        ArrayList<ScmFile> checkedOutFiles = new ArrayList<ScmFile>();
        for (File file : files) {
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(baseDestination, dest);
            if (!(destination = destination.getParentFile()).exists() && !destination.mkdirs()) {
                throw new ScmException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
            }
            FileUtils.copyFileToDirectory((File)file, (File)destination);
            File parent = file.getParentFile();
            String fileName = "/" + module + "/" + dest;
            checkedOutFiles.add(new ScmFile(fileName, ScmFileStatus.CHECKED_OUT));
        }
        return checkedOutFiles;
    }
}

