/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.checkin;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;

public class JGitCheckInCommand
extends AbstractCheckInCommand
implements GitCommand {
    protected static final String GIT_MAVEN_SECTION = "maven-scm";
    protected static final String GIT_MAILDOMAIN = "maildomain";
    protected static final String GIT_FORCE = "forceUsername";

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        CheckInScmResult checkInScmResult;
        Git git = null;
        try {
            File basedir = fileSet.getBasedir();
            git = JGitUtils.openRepo(basedir);
            boolean doCommit = false;
            if (!fileSet.getFileList().isEmpty()) {
                boolean bl = doCommit = JGitUtils.addAllFiles(git, fileSet).size() > 0;
                if (!doCommit) {
                    doCommit = git.status().call().hasUncommittedChanges();
                }
            } else {
                Status status = git.status().call();
                Set changeds = git.status().call().getModified();
                if (changeds.isEmpty()) {
                    if (!status.hasUncommittedChanges()) {
                        this.logger.warn("There are neither files to be added nor any uncommitted changes");
                        doCommit = false;
                    } else {
                        this.logger.debug("There are uncommitted changes in the git index");
                        doCommit = true;
                    }
                } else {
                    AddCommand add = git.add();
                    for (String changed : changeds) {
                        this.logger.debug("Add manually: {}", (Object)changed);
                        add.addFilepattern(changed);
                        doCommit = true;
                    }
                    add.call();
                }
            }
            List<Object> checkedInFiles = Collections.emptyList();
            if (doCommit) {
                UserInfo author = this.getAuthor(repo, git);
                UserInfo committer = this.getCommitter(repo, git);
                CommitCommand command = git.commit().setMessage(message).setAuthor(author.name, author.email);
                command.setCommitter(committer.name, committer.email);
                RevCommit commitRev = command.call();
                this.logger.info("commit done: " + commitRev.getShortMessage());
                checkedInFiles = JGitUtils.getFilesInCommit(git.getRepository(), commitRev, fileSet.getBasedir());
                if (this.logger.isDebugEnabled()) {
                    for (ScmFile scmFile : checkedInFiles) {
                        this.logger.debug("in commit: " + scmFile);
                    }
                }
            }
            if (repo.isPushChanges()) {
                String branch;
                String string = branch = version != null ? version.getName() : null;
                if (StringUtils.isBlank((String)branch)) {
                    branch = git.getRepository().getBranch();
                }
                RefSpec refSpec = new RefSpec("refs/heads/" + branch + ":" + "refs/heads/" + branch);
                this.logger.info("push changes to remote... " + refSpec);
                JGitUtils.push(git, (GitScmProviderRepository)repo, refSpec);
            }
            checkInScmResult = new CheckInScmResult("JGit checkin", checkedInFiles);
        }
        catch (Exception e) {
            try {
                throw new ScmException("JGit checkin failure!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JGitUtils.closeRepo(git);
                throw throwable;
            }
        }
        JGitUtils.closeRepo(git);
        return checkInScmResult;
    }

    private UserInfo getCommitter(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String committerName = null;
        if (!forceMvnUser && !user.isCommitterNameImplicit()) {
            committerName = user.getCommitterName();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = repo.getUser();
        }
        if (StringUtils.isBlank(committerName)) {
            committerName = user.getCommitterName();
        }
        String committerMail = null;
        if (!user.isCommitterEmailImplicit()) {
            committerMail = user.getCommitterEmail();
        }
        if (StringUtils.isBlank(committerMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((String)defaultDomain) ? defaultDomain : this.getHostname();
            committerMail = StringUtils.isNotBlank((String)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getCommitterEmail();
        }
        return new UserInfo(committerName, committerMail);
    }

    private UserInfo getAuthor(ScmProviderRepository repo, Git git) {
        boolean forceMvnUser = git.getRepository().getConfig().getBoolean(GIT_MAVEN_SECTION, GIT_FORCE, false);
        UserConfig user = (UserConfig)git.getRepository().getConfig().get(UserConfig.KEY);
        String authorName = null;
        if (!forceMvnUser && !user.isAuthorNameImplicit()) {
            authorName = user.getAuthorName();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = repo.getUser();
        }
        if (StringUtils.isBlank(authorName)) {
            authorName = user.getAuthorName();
        }
        String authorMail = null;
        if (!user.isAuthorEmailImplicit()) {
            authorMail = user.getAuthorEmail();
        }
        if (StringUtils.isBlank(authorMail)) {
            String defaultDomain = git.getRepository().getConfig().getString(GIT_MAVEN_SECTION, null, GIT_MAILDOMAIN);
            defaultDomain = StringUtils.isNotBlank((String)defaultDomain) ? defaultDomain : this.getHostname();
            authorMail = StringUtils.isNotBlank((String)repo.getUser()) ? repo.getUser() + "@" + defaultDomain : user.getAuthorEmail();
        }
        return new UserInfo(authorName, authorMail);
    }

    private String getHostname() {
        String hostname;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostname = localhost.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("failed to resolve hostname to create mail address, defaulting to 'maven-scm-provider-jgit'");
            hostname = "maven-scm-provider-jgit";
        }
        return hostname;
    }

    private static final class UserInfo {
        final String name;
        final String email;

        UserInfo(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }
}

