/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.integrity.command.tag;

import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.integrity.ExceptionHandler;
import org.apache.maven.scm.provider.integrity.Project;
import org.apache.maven.scm.provider.integrity.repository.IntegrityScmProviderRepository;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;

public class IntegrityTagCommand
extends AbstractTagCommand {
    public TagScmResult executeTagCommand(ScmProviderRepository repository, ScmFileSet fileSet, String tagName, ScmTagParameters scmTagParameters) throws ScmException {
        TagScmResult result;
        this.getLogger().info("Attempting to checkpoint project associated with sandbox " + fileSet.getBasedir().getAbsolutePath());
        String message = scmTagParameters.getMessage();
        IntegrityScmProviderRepository iRepo = (IntegrityScmProviderRepository)repository;
        try {
            String chkptLabel = this.evalGroovyExpression(tagName);
            Project.validateTag(chkptLabel);
            String msg = null == message || message.length() == 0 ? System.getProperty("message") : message;
            Project siProject = iRepo.getProject();
            if (!siProject.isBuild()) {
                Response res = siProject.checkpoint(msg, chkptLabel);
                int exitCode = res.getExitCode();
                boolean success = exitCode == 0;
                WorkItem wi = res.getWorkItem(siProject.getConfigurationPath());
                String chkpt = wi.getResult().getField("resultant").getItem().getId();
                this.getLogger().info("Successfully checkpointed project " + siProject.getConfigurationPath() + " with label '" + chkptLabel + "', new revision is " + chkpt);
                result = new TagScmResult(res.getCommandString(), wi.getResult().getMessage(), "Exit Code: " + exitCode, success);
            } else {
                this.getLogger().error("Cannot checkpoint a build project configuration: " + siProject.getConfigurationPath() + "!");
                result = new TagScmResult("si checkpoint", "Cannot checkpoint a build project configuration!", "", false);
            }
        }
        catch (CompilationFailedException cfe) {
            this.getLogger().error("Groovy Compilation Exception: " + cfe.getMessage());
            result = new TagScmResult("si checkpoint", cfe.getMessage(), "", false);
        }
        catch (APIException aex) {
            ExceptionHandler eh = new ExceptionHandler(aex);
            this.getLogger().error("MKS API Exception: " + eh.getMessage());
            this.getLogger().info(eh.getCommand() + " exited with return code " + eh.getExitCode());
            result = new TagScmResult(eh.getCommand(), eh.getMessage(), "Exit Code: " + eh.getExitCode(), false);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to checkpoint project! " + e.getMessage());
            result = new TagScmResult("si checkpoint", e.getMessage(), "", false);
        }
        return result;
    }

    public String evalGroovyExpression(String expression) {
        Binding binding = new Binding();
        binding.setVariable("env", System.getenv());
        binding.setVariable("sys", (Object)System.getProperties());
        CompilerConfiguration config = new CompilerConfiguration();
        GroovyShell shell = new GroovyShell(binding, config);
        Object result = shell.evaluate("return \"" + expression + "\"");
        if (result == null) {
            return "";
        }
        return result.toString().trim();
    }
}

