/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.cvsexe.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsStatusConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private File workingDirectory;
    private List changedFiles = new ArrayList();

    public CvsStatusConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    public void consumeLine(String line) {
        ScmFileStatus status;
        if (line.length() <= 3) {
            this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(2);
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("M")) {
            status = ScmFileStatus.MODIFIED;
        } else if (statusString.equals("D")) {
            status = ScmFileStatus.DELETED;
        } else if (statusString.equals("C")) {
            status = ScmFileStatus.CONFLICT;
        } else if (statusString.equals("?")) {
            status = ScmFileStatus.UNKNOWN;
        } else {
            if (statusString.equals("U") || statusString.equals("P")) {
                return;
            }
            this.logger.info("Unknown file status: '" + statusString + "'.");
            return;
        }
        if (!new File(this.workingDirectory, file).isFile()) {
            return;
        }
        this.changedFiles.add(new ScmFile(file, status));
    }

    public List getChangedFiles() {
        return this.changedFiles;
    }
}

