/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRev;
import org.apache.maven.scm.provider.accurev.AccuRevException;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevStat;
import org.apache.maven.scm.provider.accurev.CategorisedElements;
import org.apache.maven.scm.provider.accurev.command.AbstractAccuRevCommand;

public class AccuRevStatusCommand
extends AbstractAccuRevCommand {
    public AccuRevStatusCommand(ScmLogger logger) {
        super(logger);
    }

    protected ScmResult executeAccurevCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException, AccuRevException {
        List elements;
        File basedir;
        AccuRev accuRev = repository.getAccuRev();
        List<File> defunctElements = accuRev.stat(basedir = fileSet.getBasedir(), elements = fileSet.getFileList(), AccuRevStat.DEFUNCT);
        if (defunctElements == null) {
            return this.error(accuRev, "Failed retrieving defunct elements");
        }
        List<File> keptElements = accuRev.stat(basedir, elements, AccuRevStat.KEPT);
        if (keptElements == null) {
            return this.error(accuRev, "Failed retrieving kept elements");
        }
        ArrayList<File> modOrAddedElements = new ArrayList<File>();
        for (File file : keptElements) {
            if (defunctElements.contains(file)) continue;
            modOrAddedElements.add(file);
        }
        List<File> modifiedElements = accuRev.stat(basedir, elements, AccuRevStat.MODIFIED);
        if (modifiedElements == null) {
            return this.error(accuRev, "Failed retrieving modified elements");
        }
        modOrAddedElements.addAll(modifiedElements);
        CategorisedElements catElems = accuRev.statBackingStream(basedir, modOrAddedElements);
        if (catElems == null) {
            return this.error(accuRev, "Failed stat backing stream to split modified and added elements");
        }
        List<File> addedElements = catElems.getNonMemberElements();
        modifiedElements = catElems.getMemberElements();
        List<File> missingElements = accuRev.stat(basedir, elements, AccuRevStat.MISSING);
        if (missingElements == null) {
            return this.error(accuRev, "Failed retrieving missing elements");
        }
        List<File> externalElements = accuRev.stat(basedir, elements, AccuRevStat.EXTERNAL);
        if (externalElements == null) {
            return this.error(accuRev, "Failed retrieving external elements");
        }
        List<ScmFile> resultFiles = AccuRevStatusCommand.getScmFiles(defunctElements, ScmFileStatus.DELETED);
        resultFiles.addAll(AccuRevStatusCommand.getScmFiles(modifiedElements, ScmFileStatus.MODIFIED));
        resultFiles.addAll(AccuRevStatusCommand.getScmFiles(addedElements, ScmFileStatus.ADDED));
        resultFiles.addAll(AccuRevStatusCommand.getScmFiles(missingElements, ScmFileStatus.MISSING));
        resultFiles.addAll(AccuRevStatusCommand.getScmFiles(externalElements, ScmFileStatus.UNKNOWN));
        return new StatusScmResult(accuRev.getCommandLines(), resultFiles);
    }

    private ScmResult error(AccuRev accuRev, String message) {
        return new StatusScmResult(accuRev.getCommandLines(), "AccuRev " + message, accuRev.getErrorOutput(), false);
    }

    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (StatusScmResult)this.execute(repository, fileSet, parameters);
    }
}

