/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev;

import java.io.File;
import java.text.DateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.provider.accurev.AccuRevException;
import org.apache.maven.scm.provider.accurev.AccuRevInfo;
import org.apache.maven.scm.provider.accurev.AccuRevStat;
import org.apache.maven.scm.provider.accurev.CategorisedElements;
import org.apache.maven.scm.provider.accurev.FileDifference;
import org.apache.maven.scm.provider.accurev.Stream;
import org.apache.maven.scm.provider.accurev.Transaction;
import org.apache.maven.scm.provider.accurev.WorkSpace;
import org.apache.maven.scm.util.ThreadSafeDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AccuRev {
    public static final String DEFAULT_ACCUREV_EXECUTABLE = "accurev";
    public static final int DEFAULT_PORT = 5050;
    public static final String ACCUREV_TIME_FORMAT_STRING = "yyyy/MM/dd HH:mm:ss";
    public static final DateFormat ACCUREV_TIME_SPEC = new ThreadSafeDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final String DEFAULT_REMOVE_MESSAGE = "removed (maven-scm)";
    public static final String DEFAULT_ADD_MESSAGE = "initial version (maven-scm)";
    public static final String DEFAULT_PROMOTE_MESSAGE = "promote (maven-scm)";

    public void reset();

    public List<File> pop(File var1, String var2, Collection<File> var3) throws AccuRevException;

    public List<File> pop(File var1, Collection<File> var2) throws AccuRevException;

    public boolean mkws(String var1, String var2, File var3) throws AccuRevException;

    public List<File> update(File var1, String var2) throws AccuRevException;

    public AccuRevInfo info(File var1) throws AccuRevException;

    public boolean rmws(String var1) throws AccuRevException;

    public boolean reactivate(String var1) throws AccuRevException;

    public String getCommandLines();

    public String getErrorOutput();

    public List<File> add(File var1, List<File> var2, String var3) throws AccuRevException;

    public List<File> defunct(File var1, List<File> var2, String var3) throws AccuRevException;

    public List<File> promoteAll(File var1, String var2) throws AccuRevException;

    public List<File> promote(File var1, List<File> var2, String var3) throws AccuRevException;

    public boolean chws(File var1, String var2, String var3) throws AccuRevException;

    public boolean mksnap(String var1, String var2) throws AccuRevException;

    public List<File> statTag(String var1) throws AccuRevException;

    public CategorisedElements statBackingStream(File var1, Collection<File> var2) throws AccuRevException;

    public List<File> stat(File var1, Collection<File> var2, AccuRevStat var3) throws AccuRevException;

    public String stat(File var1) throws AccuRevException;

    public List<Transaction> history(String var1, String var2, String var3, int var4, boolean var5, boolean var6) throws AccuRevException;

    public List<FileDifference> diff(String var1, String var2, String var3) throws AccuRevException;

    public List<BlameLine> annotate(File var1, File var2) throws AccuRevException;

    public boolean login(String var1, String var2) throws AccuRevException;

    public Map<String, WorkSpace> showWorkSpaces() throws AccuRevException;

    public Map<String, WorkSpace> showRefTrees() throws AccuRevException;

    public Stream showStream(String var1) throws AccuRevException;

    public String getExecutable();

    public String getClientVersion() throws AccuRevException;
}

