/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer
implements StreamConsumer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Date parseDate(String date, String userPattern, String defaultPattern) {
        return this.parseDate(date, userPattern, defaultPattern, null);
    }

    protected Date parseDate(String date, String userPattern, String defaultPattern, Locale locale) {
        DateFormat format;
        String patternUsed = null;
        Locale localeUsed = null;
        if (StringUtils.isNotEmpty((String)userPattern)) {
            if (locale != null) {
                format = new SimpleDateFormat(userPattern, locale);
                localeUsed = locale;
            } else {
                format = new SimpleDateFormat(userPattern);
                localeUsed = Locale.getDefault();
            }
            patternUsed = userPattern;
        } else if (StringUtils.isNotEmpty((String)defaultPattern)) {
            if (locale != null) {
                format = new SimpleDateFormat(defaultPattern, locale);
                localeUsed = locale;
            } else {
                format = new SimpleDateFormat(defaultPattern);
                localeUsed = Locale.getDefault();
            }
            patternUsed = defaultPattern;
        } else {
            format = DateFormat.getDateInstance(3, Locale.ENGLISH);
            patternUsed = "DateFormat.SHORT";
            localeUsed = Locale.ENGLISH;
        }
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("skip ParseException: " + e.getMessage() + " during parsing date '" + date + "' with pattern '" + patternUsed + "' and locale '" + localeUsed + "'", (Throwable)e);
            }
            return null;
        }
    }
}

