/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionRange;
import org.eclipse.aether.util.version.UnionVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

public final class GenericVersionScheme
implements VersionScheme {
    public Version parseVersion(String version) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(version, "version cannot be null");
        return new GenericVersion(version);
    }

    public VersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(range, "range cannot be null");
        return new GenericVersionRange(range);
    }

    public VersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        Objects.requireNonNull(constraint, "constraint cannot be null");
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        String process = constraint;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            VersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            ranges.add(range);
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0 && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process);
        }
        GenericVersionConstraint result = ranges.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint)) : new GenericVersionConstraint(UnionVersionRange.from(ranges));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

