/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ProvidedChecksumsSource;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="file")
public final class FileProvidedChecksumsSource
implements ProvidedChecksumsSource {
    public static final String NAME = "file";
    static final String CONFIG_PROP_BASE_DIR = "aether.artifactResolver.providedChecksumsSource.file.baseDir";
    static final String LOCAL_REPO_PREFIX = ".checksums";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileProvidedChecksumsSource.class);
    private final FileProcessor fileProcessor;
    private final LocalPathComposer localPathComposer;

    @Inject
    public FileProvidedChecksumsSource(FileProcessor fileProcessor, LocalPathComposer localPathComposer) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
    }

    public Map<String, String> getProvidedArtifactChecksums(RepositorySystemSession session, ArtifactDownload transfer, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Path baseDir = this.getBaseDir(session);
        if (baseDir == null) {
            return null;
        }
        ArrayList<ChecksumFilePath> checksumFilePaths = new ArrayList<ChecksumFilePath>(checksumAlgorithmFactories.size());
        for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
            checksumFilePaths.add(new ChecksumFilePath(this.localPathComposer.getPathForArtifact(transfer.getArtifact(), false) + '.' + checksumAlgorithmFactory.getFileExtension(), checksumAlgorithmFactory));
        }
        return this.getProvidedChecksums(baseDir, checksumFilePaths, ArtifactIdUtils.toId((Artifact)transfer.getArtifact()));
    }

    private Map<String, String> getProvidedChecksums(Path baseDir, List<ChecksumFilePath> checksumFilePaths, String subjectId) {
        HashMap<String, String> checksums = new HashMap<String, String>();
        for (ChecksumFilePath checksumFilePath : checksumFilePaths) {
            Path checksumPath = baseDir.resolve(checksumFilePath.path);
            if (!Files.isReadable(checksumPath)) continue;
            try {
                String checksum = this.fileProcessor.readChecksum(checksumPath.toFile());
                if (checksum == null) continue;
                LOGGER.debug("Resolved provided checksum '{}:{}' for '{}'", new Object[]{checksumFilePath.checksumAlgorithmFactory.getName(), checksum, subjectId});
                checksums.put(checksumFilePath.checksumAlgorithmFactory.getName(), checksum);
            }
            catch (IOException e) {
                LOGGER.warn("Could not read provided checksum for '{}' at path '{}'", new Object[]{subjectId, checksumPath, e});
            }
        }
        return checksums.isEmpty() ? null : checksums;
    }

    private Path getBaseDir(RepositorySystemSession session) {
        String baseDirPath = ConfigUtils.getString((RepositorySystemSession)session, null, (String[])new String[]{CONFIG_PROP_BASE_DIR});
        Path baseDir = baseDirPath != null ? Paths.get(baseDirPath, new String[0]) : session.getLocalRepository().getBasedir().toPath().resolve(LOCAL_REPO_PREFIX);
        if (!Files.isDirectory(baseDir, new LinkOption[0])) {
            return null;
        }
        return baseDir;
    }

    private static final class ChecksumFilePath {
        private final String path;
        private final ChecksumAlgorithmFactory checksumAlgorithmFactory;

        private ChecksumFilePath(String path, ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            this.path = path;
            this.checksumAlgorithmFactory = checksumAlgorithmFactory;
        }
    }
}

