/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractRunGoalsPhase;
import org.apache.maven.shared.release.util.PomFinder;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunPerformGoalsPhase
extends AbstractRunGoalsPhase {
    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        File matchingPom;
        String pomFileName;
        String additionalArguments = releaseDescriptor.getAdditionalArguments();
        if (releaseDescriptor.isUseReleaseProfile()) {
            additionalArguments = !StringUtils.isEmpty((String)additionalArguments) ? additionalArguments + " -DperformRelease=true" : "-DperformRelease=true";
        }
        additionalArguments = !StringUtils.isEmpty((String)additionalArguments) ? additionalArguments + " -f pom.xml" : "-f pom.xml";
        String workDir = releaseDescriptor.getWorkingDirectory();
        if (workDir == null) {
            workDir = System.getProperty("user.dir");
        }
        if ((pomFileName = releaseDescriptor.getPomFileName()) == null) {
            pomFileName = "pom.xml";
        }
        File pomFile = new File(workDir, pomFileName);
        PomFinder pomFinder = new PomFinder(this.getLogger());
        boolean foundPom = pomFinder.parsePom(pomFile);
        if (foundPom && (matchingPom = pomFinder.findMatchingPom(new File(releaseDescriptor.getCheckoutDirectory()))) != null) {
            this.getLogger().info("Invoking perform goals in directory " + matchingPom.getParent());
            releaseDescriptor.setCheckoutDirectory(matchingPom.getParent());
        }
        return this.execute(releaseDescriptor, releaseEnvironment, new File(releaseDescriptor.getCheckoutDirectory()), additionalArguments);
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.logInfo(result, "Executing perform goals");
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        return result;
    }

    @Override
    protected String getGoals(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getPerformGoals();
    }
}

