/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.war.util.PathSet;
import org.apache.maven.plugin.war.util.WebappStructure;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class WebappStructureSerializer {
    private static final XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebappStructure fromXml(File file) throws IOException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)file);
            WebappStructure webappStructure = (WebappStructure)xStream.fromXML((Reader)reader);
            return webappStructure;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXml(WebappStructure webappStructure, File targetFile) throws IOException {
        XmlStreamWriter writer = null;
        try {
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException("Could not create parent [" + targetFile.getParentFile().getAbsolutePath() + "]");
            }
            if (!targetFile.exists() && !targetFile.createNewFile()) {
                throw new IOException("Could not create file [" + targetFile.getAbsolutePath() + "]");
            }
            writer = WriterFactory.newXmlWriter((File)targetFile);
            xStream.toXML((Object)webappStructure, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    static {
        xStream.alias("webapp-structure", WebappStructure.class);
        xStream.alias("path-set", PathSet.class);
        xStream.alias("dependency", Dependency.class);
    }
}

