/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.site.AbstractDeployMojo;

public class SiteStageMojo
extends AbstractDeployMojo {
    private File stagingDirectory;

    protected String getDeployRepositoryID() throws MojoExecutionException {
        return "stagingLocal";
    }

    protected String getDeployRepositoryURL() throws MojoExecutionException {
        String stageDir = this.stagingDirectory == null ? null : this.stagingDirectory.getAbsolutePath();
        String outputDir = this.getStagingDirectory(stageDir);
        this.getLog().info((CharSequence)("Using this base directory for staging: " + outputDir));
        File outputDirectory = new File(outputDir);
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        return "file://" + outputDirectory.getAbsolutePath();
    }

    private String getStagingDirectory(String usersStagingDirectory) {
        String topLevelURL = null;
        if (usersStagingDirectory != null) {
            this.getLog().debug((CharSequence)("stagingDirectory specified by the user: " + usersStagingDirectory));
            topLevelURL = usersStagingDirectory;
        } else {
            topLevelURL = this.getTopLevelBuildDirectory().getAbsolutePath() + "/" + "staging/";
            this.getLog().debug((CharSequence)("stagingDirectory NOT specified, using the top level project: " + topLevelURL));
        }
        return topLevelURL;
    }
}

