/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.SiteMap;
import org.apache.maven.reporting.MavenReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMojo
extends AbstractSiteRenderingMojo {
    protected File outputDirectory;
    private boolean generateReports;
    private boolean generateSitemap;
    private boolean validate;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"maven.site.skip = true: Skipping site generation");
            return;
        }
        this.checkMavenVersion();
        List<Object> filteredReports = this.generateReports ? this.filterReports(this.reports) : Collections.emptyList();
        try {
            List localesList = this.siteTool.getAvailableLocales(this.locales);
            Locale defaultLocale = (Locale)localesList.get(0);
            Locale.setDefault(defaultLocale);
            for (Locale locale : localesList) {
                this.renderLocale(locale, filteredReports);
            }
        }
        catch (RendererException e) {
            throw new MojoExecutionException("Error during page generation", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during site generation", (Exception)e);
        }
    }

    private void renderLocale(Locale locale, List<MavenReport> reports) throws IOException, RendererException, MojoFailureException, MojoExecutionException {
        SiteRenderingContext context = this.createSiteRenderingContext(locale);
        context.setInputEncoding(this.getInputEncoding());
        context.setOutputEncoding(this.getOutputEncoding());
        context.setValidate(this.validate);
        if (this.validate) {
            this.getLog().info((CharSequence)"Validation is switched on, xml input documents will be validated!");
        }
        Map documents = this.locateDocuments(context, reports, locale);
        File outputDir = this.getOutputDirectory(locale);
        for (MavenReport report : reports) {
            report.setReportOutputDirectory(outputDir);
        }
        this.siteRenderer.render(documents.values(), context, outputDir);
        if (this.generateSitemap) {
            this.getLog().info((CharSequence)"Generating Sitemap.");
            new SiteMap(this.getOutputEncoding(), this.i18n).generate(context.getDecoration(), this.generatedSiteDirectory, locale);
        }
        context.getSiteDirectories().clear();
        context.addSiteDirectory(this.generatedSiteDirectory);
        documents = this.siteRenderer.locateDocumentFiles(context);
        this.siteRenderer.render(documents.values(), context, outputDir);
    }

    private File getOutputDirectory(Locale locale) {
        File file = locale.getLanguage().equals(Locale.getDefault().getLanguage()) ? this.outputDirectory : new File(this.outputDirectory, locale.getLanguage());
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

