package org.apache.maven.plugins.site;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-site-plugin.<br/> Call <pre>  mvn site:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Mon Apr 23 21:50:23 CEST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-site-plugin:2.4", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Site Plugin 2", 0 );
        append( sb, "The Maven Site Plugin is a plugin that generates a site for the current project.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 9 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "attach-descriptor".equals( goal ) )
        {
            append( sb, "site:attach-descriptor", 0 );
            append( sb, "Adds the site descriptor (site.xml) to the list of files to be installed/deployed.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "deploy".equals( goal ) )
        {
            append( sb, "site:deploy", 0 );
            append( sb, "Deploys the generated site using wagon supported protocols to the site URL specified in the <distributionManagement> section of the POM.\nFor scp protocol, the website files are packaged by wagon into zip archive, then the archive is transfered to the remote host, next it is un-archived which is much faster than making a file by file copy.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "chmod (Default: true)", 2 );
                append( sb, "Whether to run the \'chmod\' command on the remote site after the deploy. Defaults to \'true\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodMode (Default: g+w,a+rX)", 2 );
                append( sb, "The mode used by the \'chmod\' command. Only used if chmod = true. Defaults to \'g+w,a+rX\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.mode}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodOptions (Default: -Rf)", 2 );
                append( sb, "The options used by the \'chmod\' command. Only used if chmod = true. Defaults to \'-Rf\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.options}", 3 );
                append( sb, "", 0 );

                append( sb, "inputDirectory", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.reporting.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDeploy (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip site deployment.", 3 );
                append( sb, "Expression: ${maven.site.deploy.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "effective-site".equals( goal ) )
        {
            append( sb, "site:effective-site", 0 );
            append( sb, "Displays the effective site descriptor as an XML for this build, after inheritance and interpolation of site.xml.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory (Default: ${project.build.directory}/generated-site)", 2 );
                append( sb, "Directory containing generated documentation. This is used to pick up other source docs that might have been generated at build time.", 3 );
                append( sb, "", 0 );

                append( sb, "generateProjectInfo (Default: true)", 2 );
                append( sb, "Whether to generate the summary page for project reports: project-info.html.", 3 );
                append( sb, "Expression: ${generateProjectInfo}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3 );
                append( sb, "Expression: ${output}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "relativizeDecorationLinks (Default: true)", 2 );
                append( sb, "Make links in the site descriptor relative to the project URL. By default, any absolute links that appear in the site descriptor, e.g. banner hrefs, breadcrumbs, menu links, etc., will be made relative to project.url. Links will not be changed if this is set to false, or if the project has no URL defined.", 3 );
                append( sb, "Expression: ${relativizeDecorationLinks}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Default template page.", 3 );
                append( sb, "Expression: ${template}", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "Expression: ${templateDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "Expression: ${templateFile}", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Deprecated. use the standard m2 directory layout", 3 );
                append( sb, "", 0 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "site:help", 0 );
            append( sb, "Display help information on maven-site-plugin.\nCall\n\u00a0\u00a0mvn\u00a0site:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jar".equals( goal ) )
        {
            append( sb, "site:jar", 0 );
            append( sb, "Bundles the site output into a JAR so that it can be deployed to a repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attach (Default: true)", 2 );
                append( sb, "Specifies whether to attach the generated artifact to the project.", 3 );
                append( sb, "Expression: ${site.attach}", 3 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "finalName", 2 );
                append( sb, "Specifies the filename that will be used for the generated jar file. Please note that \'-site\' will be appended to the file name.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.finalName}", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory (Default: ${project.build.directory}/generated-site)", 2 );
                append( sb, "Directory containing generated documentation. This is used to pick up other source docs that might have been generated at build time.", 3 );
                append( sb, "", 0 );

                append( sb, "generateProjectInfo (Default: true)", 2 );
                append( sb, "Whether to generate the summary page for project reports: project-info.html.", 3 );
                append( sb, "Expression: ${generateProjectInfo}", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "Expression: ${generateReports}", 3 );
                append( sb, "", 0 );

                append( sb, "generateSitemap (Default: false)", 2 );
                append( sb, "Generate a sitemap. The result will be a \'sitemap.html\' file at the site root.", 3 );
                append( sb, "Expression: ${generateSitemap}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "jarOutputDirectory", 2 );
                append( sb, "Specifies the directory where the generated jar file will be put.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory where the project sites and report distributions will be generated.", 3 );
                append( sb, "Expression: ${siteOutputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "relativizeDecorationLinks (Default: true)", 2 );
                append( sb, "Make links in the site descriptor relative to the project URL. By default, any absolute links that appear in the site descriptor, e.g. banner hrefs, breadcrumbs, menu links, etc., will be made relative to project.url. Links will not be changed if this is set to false, or if the project has no URL defined.", 3 );
                append( sb, "Expression: ${relativizeDecorationLinks}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip site generation.", 3 );
                append( sb, "Expression: ${maven.site.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Default template page.", 3 );
                append( sb, "Expression: ${template}", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "Expression: ${templateDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "Expression: ${templateFile}", 3 );
                append( sb, "", 0 );

                append( sb, "validate (Default: false)", 2 );
                append( sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3 );
                append( sb, "Expression: ${validate}", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Deprecated. use the standard m2 directory layout", 3 );
                append( sb, "", 0 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "run".equals( goal ) )
        {
            append( sb, "site:run", 0 );
            append( sb, "Starts the site up, rendering documents as requested for faster editing. It uses Jetty as the web server.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory (Default: ${project.build.directory}/generated-site)", 2 );
                append( sb, "Directory containing generated documentation. This is used to pick up other source docs that might have been generated at build time.", 3 );
                append( sb, "", 0 );

                append( sb, "generateProjectInfo (Default: true)", 2 );
                append( sb, "Whether to generate the summary page for project reports: project-info.html.", 3 );
                append( sb, "Expression: ${generateProjectInfo}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 8080)", 2 );
                append( sb, "The port to execute the HTTP server on.", 3 );
                append( sb, "Expression: ${port}", 3 );
                append( sb, "", 0 );

                append( sb, "relativizeDecorationLinks (Default: true)", 2 );
                append( sb, "Make links in the site descriptor relative to the project URL. By default, any absolute links that appear in the site descriptor, e.g. banner hrefs, breadcrumbs, menu links, etc., will be made relative to project.url. Links will not be changed if this is set to false, or if the project has no URL defined.", 3 );
                append( sb, "Expression: ${relativizeDecorationLinks}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Default template page.", 3 );
                append( sb, "Expression: ${template}", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "Expression: ${templateDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "Expression: ${templateFile}", 3 );
                append( sb, "", 0 );

                append( sb, "tempWebappDirectory", 2 );
                append( sb, "Where to create the dummy web application.", 3 );
                append( sb, "Expression: ${project.build.directory}/site-webapp", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Deprecated. use the standard m2 directory layout", 3 );
                append( sb, "", 0 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "site".equals( goal ) )
        {
            append( sb, "site:site", 0 );
            append( sb, "Generates the site for a single project.\nNote that links between module sites in a multi module build will not work.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attributes", 2 );
                append( sb, "The template properties for rendering the site.", 3 );
                append( sb, "", 0 );

                append( sb, "generatedSiteDirectory (Default: ${project.build.directory}/generated-site)", 2 );
                append( sb, "Directory containing generated documentation. This is used to pick up other source docs that might have been generated at build time.", 3 );
                append( sb, "", 0 );

                append( sb, "generateProjectInfo (Default: true)", 2 );
                append( sb, "Whether to generate the summary page for project reports: project-info.html.", 3 );
                append( sb, "Expression: ${generateProjectInfo}", 3 );
                append( sb, "", 0 );

                append( sb, "generateReports (Default: true)", 2 );
                append( sb, "Convenience parameter that allows you to disable report generation.", 3 );
                append( sb, "Expression: ${generateReports}", 3 );
                append( sb, "", 0 );

                append( sb, "generateSitemap (Default: false)", 2 );
                append( sb, "Generate a sitemap. The result will be a \'sitemap.html\' file at the site root.", 3 );
                append( sb, "Expression: ${generateSitemap}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "moduleExcludes", 2 );
                append( sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in \'-m1.fml\' recursively)\n>The configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0\'apt\',\u00a0\'fml\'\u00a0or\u00a0\'xdoc\'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here\'s\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Directory where the project sites and report distributions will be generated.", 3 );
                append( sb, "Expression: ${siteOutputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "relativizeDecorationLinks (Default: true)", 2 );
                append( sb, "Make links in the site descriptor relative to the project URL. By default, any absolute links that appear in the site descriptor, e.g. banner hrefs, breadcrumbs, menu links, etc., will be made relative to project.url. Links will not be changed if this is set to false, or if the project has no URL defined.", 3 );
                append( sb, "Expression: ${relativizeDecorationLinks}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip site generation.", 3 );
                append( sb, "Expression: ${maven.site.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "template", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Default template page.", 3 );
                append( sb, "Expression: ${template}", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: src/site)", 2 );
                append( sb, "Deprecated. use templateFile or skinning instead", 3 );
                append( sb, "", 0 );
                append( sb, "Directory containing the template page.", 3 );
                append( sb, "Expression: ${templateDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "templateFile", 2 );
                append( sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3 );
                append( sb, "Expression: ${templateFile}", 3 );
                append( sb, "", 0 );

                append( sb, "validate (Default: false)", 2 );
                append( sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3 );
                append( sb, "Expression: ${validate}", 3 );
                append( sb, "", 0 );

                append( sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2 );
                append( sb, "Deprecated. use the standard m2 directory layout", 3 );
                append( sb, "", 0 );
                append( sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stage".equals( goal ) )
        {
            append( sb, "site:stage", 0 );
            append( sb, "Deploys the generated site to a local staging or mock directory based on the site URL specified in the <distributionManagement> section of the POM.\nIt can be used to test that links between module sites in a multi-module build works.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "chmod (Default: true)", 2 );
                append( sb, "Whether to run the \'chmod\' command on the remote site after the deploy. Defaults to \'true\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodMode (Default: g+w,a+rX)", 2 );
                append( sb, "The mode used by the \'chmod\' command. Only used if chmod = true. Defaults to \'g+w,a+rX\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.mode}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodOptions (Default: -Rf)", 2 );
                append( sb, "The options used by the \'chmod\' command. Only used if chmod = true. Defaults to \'-Rf\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.options}", 3 );
                append( sb, "", 0 );

                append( sb, "inputDirectory", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.reporting.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDeploy (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip site deployment.", 3 );
                append( sb, "Expression: ${maven.site.deploy.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "stagingDirectory", 2 );
                append( sb, "Staging directory location. This needs to be an absolute path, like C:\\stagingArea\\myProject\\ on Windows or /stagingArea/myProject/ on Unix. If this is not specified, the site will be staged in ${project.build.directory}/staging.", 3 );
                append( sb, "Expression: ${stagingDirectory}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stage-deploy".equals( goal ) )
        {
            append( sb, "site:stage-deploy", 0 );
            append( sb, "Deploys the generated site to a staging or mock directory to the site URL specified in the <distributionManagement> section of the POM, using wagon supported protocols", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "chmod (Default: true)", 2 );
                append( sb, "Whether to run the \'chmod\' command on the remote site after the deploy. Defaults to \'true\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodMode (Default: g+w,a+rX)", 2 );
                append( sb, "The mode used by the \'chmod\' command. Only used if chmod = true. Defaults to \'g+w,a+rX\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.mode}", 3 );
                append( sb, "", 0 );

                append( sb, "chmodOptions (Default: -Rf)", 2 );
                append( sb, "The options used by the \'chmod\' command. Only used if chmod = true. Defaults to \'-Rf\'.", 3 );
                append( sb, "Expression: ${maven.site.chmod.options}", 3 );
                append( sb, "", 0 );

                append( sb, "inputDirectory", 2 );
                append( sb, "Directory containing the generated project sites and report distributions.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.reporting.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the input encoding.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "locales", 2 );
                append( sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3 );
                append( sb, "Expression: ${locales}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "Specifies the output encoding.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "siteDirectory (Default: ${basedir}/src/site)", 2 );
                append( sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3 );
                append( sb, "", 0 );

                append( sb, "skipDeploy (Default: false)", 2 );
                append( sb, "Set this to \'true\' to skip site deployment.", 3 );
                append( sb, "Expression: ${maven.site.deploy.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "stagingRepositoryId", 2 );
                append( sb, "The identifier of the repository where the staging site will be deployed. This id will be used to lookup a corresponding <server> entry from the settings.xml. If a matching <server> entry is found, its configured credentials will be used for authentication. If this is not specified, then the corresponding value of distributionManagement.site.id will be taken as default, unless this is not defined either then the String \'stagingSite\' is used. (Note: until v. 2.3 and 3.0-beta-3 the String \'stagingSite\' is always used.)", 3 );
                append( sb, "Expression: ${stagingRepositoryId}", 3 );
                append( sb, "", 0 );

                append( sb, "stagingSiteURL", 2 );
                append( sb, "The staged site will be deployed to this URL. If you don\'t specify this, the default-value will be \'${project.distributionManagement.site.url}/staging\', where \'project\' is either the current project or, in a reactor build, the top level project in the reactor.\nNote that even if you specify this plugin parameter, you still need to indicate ${project.distributionManagement.site.url} at least in your top level project in order for relative links between modules to be resolved correctly.\n", 3 );
                append( sb, "Expression: ${stagingSiteURL}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
