/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.plugins.site.CategorySummaryDocumentRenderer;
import org.apache.maven.plugins.site.ReportDocumentRenderer;
import org.apache.maven.reporting.MavenReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteRenderingMojo
extends AbstractSiteMojo {
    private Map<String, String> moduleExcludes;
    private DecorationModelInheritanceAssembler assembler;
    private List<ArtifactRepository> repositories;
    private File templateDirectory;
    private String template;
    private File templateFile;
    private Map<String, Object> attributes;
    protected Renderer siteRenderer;
    protected List<MavenReport> reports;
    private File xdocDirectory;
    protected File generatedSiteDirectory;
    private boolean relativizeDecorationLinks;
    private boolean generateProjectInfo;

    protected List<MavenReport> filterReports(List<MavenReport> reports) {
        ArrayList<MavenReport> filteredReports = new ArrayList<MavenReport>(reports.size());
        for (MavenReport report : reports) {
            if (!report.canGenerateReport()) continue;
            filteredReports.add(report);
        }
        return filteredReports;
    }

    protected SiteRenderingContext createSiteRenderingContext(Locale locale) throws MojoExecutionException, IOException, MojoFailureException {
        SiteRenderingContext context;
        File skinFile;
        DecorationModel decorationModel;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if (this.attributes.get("project") == null) {
            this.attributes.put("project", this.project);
        }
        if (this.attributes.get("inputEncoding") == null) {
            this.attributes.put("inputEncoding", this.getInputEncoding());
        }
        if (this.attributes.get("outputEncoding") == null) {
            this.attributes.put("outputEncoding", this.getOutputEncoding());
        }
        for (Map.Entry<Object, Object> entry : this.project.getProperties().entrySet()) {
            this.attributes.put((String)entry.getKey(), entry.getValue());
        }
        try {
            decorationModel = this.siteTool.getDecorationModel(this.project, this.reactorProjects, this.localRepository, this.repositories, this.siteTool.getRelativePath(this.siteDirectory.getAbsolutePath(), this.project.getBasedir().getAbsolutePath()), locale, this.getInputEncoding(), this.getOutputEncoding());
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.relativizeDecorationLinks) {
            String url = this.project.getUrl();
            if (url == null) {
                this.getLog().warn((CharSequence)"No project URL defined - decoration links will not be relativized!");
            } else {
                this.getLog().info((CharSequence)("Relativizing decoration links with respect to project URL: " + url));
                this.assembler.resolvePaths(decorationModel, url);
            }
        }
        if (this.template != null) {
            if (this.templateFile != null) {
                this.getLog().warn((CharSequence)"'template' configuration is ignored when 'templateFile' is set");
            } else {
                this.templateFile = new File(this.templateDirectory, this.template);
            }
        }
        try {
            Artifact skinArtifact = this.siteTool.getSkinArtifactFromRepository(this.localRepository, this.repositories, decorationModel);
            this.getLog().info((CharSequence)("Rendering site with " + skinArtifact.getId() + " skin."));
            skinFile = skinArtifact.getFile();
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.templateFile != null) {
            if (!this.templateFile.exists()) {
                throw new MojoFailureException("Template file '" + this.templateFile + "' does not exist");
            }
            context = this.siteRenderer.createContextForTemplate(this.templateFile, skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        } else {
            context = this.siteRenderer.createContextForSkin(skinFile, this.attributes, decorationModel, this.project.getName(), locale);
        }
        if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
            context.addSiteDirectory(new File(this.siteDirectory, locale.getLanguage()));
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "xdoc");
            context.addModuleDirectory(new File(this.xdocDirectory, locale.getLanguage()), "fml");
        } else {
            context.addSiteDirectory(this.siteDirectory);
            context.addModuleDirectory(this.xdocDirectory, "xdoc");
            context.addModuleDirectory(this.xdocDirectory, "fml");
        }
        if (this.moduleExcludes != null) {
            context.setModuleExcludes(this.moduleExcludes);
        }
        return context;
    }

    protected Map<String, MavenReport> locateReports(List<MavenReport> reports, Map<String, DocumentRenderer> documents, Locale locale) {
        HashMap<String, MavenReport> reportsByOutputName = new HashMap<String, MavenReport>();
        Iterator<MavenReport> i = reports.iterator();
        while (i.hasNext()) {
            MavenReport report = i.next();
            String outputName = report.getOutputName() + ".html";
            reportsByOutputName.put(report.getOutputName(), report);
            if (documents.containsKey(outputName)) {
                String displayLanguage = locale.getDisplayLanguage(Locale.ENGLISH);
                this.getLog().info((CharSequence)("Skipped \"" + report.getName(locale) + "\" report, file \"" + outputName + "\" already exists for the " + displayLanguage + " version."));
                i.remove();
                continue;
            }
            RenderingContext renderingContext = new RenderingContext(this.siteDirectory, outputName);
            ReportDocumentRenderer renderer = new ReportDocumentRenderer(report, renderingContext, this.getLog());
            documents.put(outputName, renderer);
        }
        return reportsByOutputName;
    }

    protected Map<String, List<MavenReport>> categoriseReports(Collection<MavenReport> reports) {
        HashMap<String, List<MavenReport>> categories = new HashMap<String, List<MavenReport>>();
        for (MavenReport report : reports) {
            ArrayList<MavenReport> categoryReports = (ArrayList<MavenReport>)categories.get(report.getCategoryName());
            if (categoryReports == null) {
                categoryReports = new ArrayList<MavenReport>();
                categories.put(report.getCategoryName(), categoryReports);
            }
            categoryReports.add(report);
        }
        return categories;
    }

    protected Map<String, DocumentRenderer> locateDocuments(SiteRenderingContext context, List<MavenReport> reports, Locale locale) throws IOException, RendererException {
        CategorySummaryDocumentRenderer renderer;
        String desc2;
        String desc1;
        String title;
        RenderingContext renderingContext;
        List<MavenReport> categoryReports;
        Map documents = this.siteRenderer.locateDocumentFiles(context);
        Map<String, MavenReport> reportsByOutputName = this.locateReports(reports, documents, locale);
        Map<String, List<MavenReport>> categories = this.categoriseReports(reportsByOutputName.values());
        this.siteTool.populateReportsMenu(context.getDecoration(), locale, categories);
        this.populateReportItems(context.getDecoration(), locale, reportsByOutputName);
        if (categories.containsKey("Project Info") && this.generateProjectInfo) {
            categoryReports = categories.get("Project Info");
            renderingContext = new RenderingContext(this.siteDirectory, "project-info.html");
            title = this.i18n.getString("site-plugin", locale, "report.information.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.information.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.information.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        if (categories.containsKey("Project Reports")) {
            categoryReports = categories.get("Project Reports");
            renderingContext = new RenderingContext(this.siteDirectory, "project-reports.html");
            title = this.i18n.getString("site-plugin", locale, "report.project.title");
            renderer = new CategorySummaryDocumentRenderer(renderingContext, title, desc1 = this.i18n.getString("site-plugin", locale, "report.project.description1"), desc2 = this.i18n.getString("site-plugin", locale, "report.project.description2"), this.i18n, categoryReports, this.getLog());
            if (!documents.containsKey(renderer.getOutputName())) {
                documents.put(renderer.getOutputName(), renderer);
            } else {
                this.getLog().info((CharSequence)("Category summary '" + renderer.getOutputName() + "' skipped; already exists"));
            }
        }
        return documents;
    }

    protected void populateReportItems(DecorationModel decorationModel, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        for (Menu menu : decorationModel.getMenus()) {
            this.populateItemRefs(menu.getItems(), locale, reportsByOutputName);
        }
    }

    private void populateItemRefs(List<MenuItem> items, Locale locale, Map<String, MavenReport> reportsByOutputName) {
        Iterator<MenuItem> i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = i.next();
            if (item.getRef() != null) {
                MavenReport report = reportsByOutputName.get(item.getRef());
                if (report != null) {
                    if (item.getName() == null) {
                        item.setName(report.getName(locale));
                    }
                    if (item.getHref() == null || item.getHref().length() == 0) {
                        item.setHref(report.getOutputName() + ".html");
                    }
                } else {
                    this.getLog().warn((CharSequence)("Unrecognised reference: '" + item.getRef() + "'"));
                    i.remove();
                }
            }
            this.populateItemRefs(item.getItems(), locale, reportsByOutputName);
        }
    }
}

